/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.v2;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.notify.engine.v2.NotificationRequestResourceV2;
import org.tiogasolutions.notify.engine.v2.NotificationsResourceV2;
import org.tiogasolutions.notify.engine.v2.RouteCatalogResourceV2;
import org.tiogasolutions.notify.engine.v2.SimpleRequestEntryResourceV2;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.domain.DomainSummary;

public class ClientResourceV2 {
    private final ExecutionManager em;

    public ClientResourceV2(ExecutionManager em) {
        this.em = em;
    }

    @GET
    @Produces(value={"application/json"})
    public DomainProfile getDomainProfile() {
        String domainName = this.em.context().getDomainName();
        return this.em.getDomainKernel().findByDomainName(domainName);
    }

    @GET
    @Path(value="summary")
    @Produces(value={"application/json"})
    public Response getDomainSummary() {
        try {
            String domainName = this.em.context().getDomainName();
            DomainSummary summary = this.em.getDomainKernel().fetchSummary(domainName);
            return Response.ok((Object)summary).build();
        }
        catch (ApiNotFoundException e) {
            return Response.status((int)404).entity((Object)e).build();
        }
    }

    @Path(value="/notifications")
    public NotificationsResourceV2 getNotificationsResource(@Context Request request) {
        return new NotificationsResourceV2(request, this.em);
    }

    @Path(value="/route-catalog")
    public RouteCatalogResourceV2 getRouteCatalogResource() {
        return new RouteCatalogResourceV2(this.em);
    }

    @Path(value="/requests")
    public NotificationRequestResourceV2 getRequestResourceV1() {
        return new NotificationRequestResourceV2(this.em);
    }

    @Path(value="/simple-request-entry")
    public SimpleRequestEntryResourceV2 getSimpleRequestEntryV1() {
        return new SimpleRequestEntryResourceV2(this.em);
    }
}

