/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.v2;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.dev.common.exceptions.ApiBadRequestException;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.notify.kernel.execution.ExecutionContext;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.route.RouteCatalog;

public class RouteCatalogResourceV2 {
    private static final Logger log = LoggerFactory.getLogger(RouteCatalogResourceV2.class);
    private final ExecutionManager executionManager;

    public RouteCatalogResourceV2(ExecutionManager executionManager) {
        this.executionManager = executionManager;
    }

    private DomainProfile getDomainProfile() {
        ExecutionContext ec = this.executionManager.context();
        return this.executionManager.getDomainKernel().findByApiKey(ec.getApiKey());
    }

    @GET
    @Produces(value={"application/json"})
    public RouteCatalog getRouteCatalog() {
        return this.getDomainProfile().getRouteCatalog();
    }

    @PUT
    @Produces(value={"application/json"})
    public RouteCatalog putRouteCatalog(String json) throws IOException {
        ExceptionUtils.assertNotZeroLength((String)json, (String)"route-catalog", ApiBadRequestException.class, ApiBadRequestException.class);
        RouteCatalog routeCatalog = (RouteCatalog)this.executionManager.getObjectMapper().readValue(json, RouteCatalog.class);
        DomainProfile returnProfile = this.executionManager.getDomainKernel().updateRouteCatalog(this.getDomainProfile(), routeCatalog);
        return returnProfile.getRouteCatalog();
    }
}

