/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.web;

import java.net.URI;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tiogasolutions.lib.jaxrs.providers.TiogaJaxRsExceptionMapper;
import org.tiogasolutions.notify.notifier.Notifier;

@Provider
public class NotifyExceptionMapper
extends TiogaJaxRsExceptionMapper {
    private final Notifier notifier;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Autowired
    public NotifyExceptionMapper(Notifier notifier) {
        this.notifier = notifier;
    }

    protected void log4xxException(String msg, Throwable throwable, int statusCode) {
        super.log4xxException(msg, throwable, statusCode);
    }

    protected void log5xxException(String msg, Throwable throwable, int statusCode) {
        super.log5xxException(msg, throwable, statusCode);
        try {
            this.notifier.begin().summary(msg).exception(throwable).trait("action", (Object)"Unhandled 5xx").trait("http_status_code", (Object)statusCode).trait("http_uri", (Object)NotifyExceptionMapper.cleanUrl((URI)this.getUriInfo().getRequestUri())).send().get();
        }
        catch (Exception ex) {
            this.log.error("Exception sending notification", (Throwable)ex);
        }
    }
}

