/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.builder;

import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.notify.notifier.builder.NotificationBuilderCallback;
import org.tiogasolutions.notify.notifier.builder.NotificationBuilderCallbacks;
import org.tiogasolutions.notify.notifier.builder.NotificationTrait;
import org.tiogasolutions.notify.notifier.send.NotificationAttachment;
import org.tiogasolutions.notify.notifier.send.NotificationExceptionInfo;
import org.tiogasolutions.notify.notifier.send.NotificationLink;
import org.tiogasolutions.notify.notifier.send.NotificationSender;
import org.tiogasolutions.notify.notifier.send.SendNotificationRequest;
import org.tiogasolutions.notify.notifier.send.SendNotificationResponse;
import org.tiogasolutions.notify.notifier.send.SendNotificationResponseType;

public class NotificationBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NotificationSender sender;
    private final NotificationBuilderCallbacks callbacks;
    private boolean internal;
    private String topic;
    private String trackingId;
    private String summary;
    private ZonedDateTime createdAt;
    private NotificationExceptionInfo exceptionInfo;
    private List<NotificationTrait> traits = new ArrayList<NotificationTrait>();
    private List<NotificationLink> links = new ArrayList<NotificationLink>();
    private List<NotificationAttachment> attachments = new ArrayList<NotificationAttachment>();

    public NotificationBuilder(NotificationSender sender, NotificationBuilderCallbacks callbacks) {
        this.sender = sender;
        this.callbacks = callbacks.copy();
        callbacks.callBegin(this);
    }

    public NotificationBuilder onBegin(NotificationBuilderCallback callback) {
        this.callbacks.onBegin(callback);
        return this;
    }

    public NotificationBuilder onBeforeSend(NotificationBuilderCallback callback) {
        this.callbacks.onBeforeSend(callback);
        return this;
    }

    public Future<SendNotificationResponse> send() {
        this.callbacks.callBeforeSend(this);
        SendNotificationRequest request = new SendNotificationRequest(this.internal, this.topic, this.summary, this.trackingId, this.createdAt, NotificationTrait.toTraitMap(this.traits), this.links, this.exceptionInfo, this.attachments);
        Future<SendNotificationResponse> futureResponse = this.sender.send(request);
        new Thread(() -> {
            block4: {
                try {
                    SendNotificationResponse response = (SendNotificationResponse)futureResponse.get();
                    SendNotificationResponseType responseType = response.getResponseType();
                    if (responseType.isSuccess()) {
                        this.callbacks.callOnSuccess(response);
                        break block4;
                    }
                    if (responseType.isFailure()) {
                        this.callbacks.callOnFailure(response);
                        break block4;
                    }
                    throw new UnsupportedOperationException(String.format("The response type %s is not supported.", new Object[]{responseType}));
                }
                catch (Exception e) {
                    this.log.error("Exception getting future response");
                }
            }
        }).start();
        return futureResponse;
    }

    public NotificationBuilder topic(String topic) {
        this.topic = topic;
        return this;
    }

    public NotificationBuilder trackingId(String trackingId) {
        this.trackingId = trackingId;
        return this;
    }

    public NotificationBuilder summary(String summary) {
        this.summary = summary;
        return this;
    }

    public NotificationBuilder summary(String format, Object ... args) {
        this.summary = String.format(format, args);
        return this;
    }

    @Deprecated
    public NotificationBuilder internal() {
        this.internal = true;
        return this;
    }

    public NotificationBuilder createdAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public NotificationBuilder trait(String name, Object value) {
        String str = value != null ? value.toString() : null;
        this.traits.add(new NotificationTrait(name, str));
        return this;
    }

    public NotificationBuilder traits(String ... traits) {
        this.traits.addAll(NotificationTrait.toTraits(Arrays.asList(traits)));
        return this;
    }

    public NotificationBuilder traits(Map<String, String> traitMap) {
        this.traits.addAll(NotificationTrait.toTraits(traitMap));
        return this;
    }

    public NotificationBuilder link(String name, String href) {
        this.links.add(new NotificationLink(name, href));
        return this;
    }

    public NotificationBuilder links(Collection<NotificationLink> linksArg) {
        this.links.addAll(linksArg);
        return this;
    }

    public NotificationBuilder links(NotificationLink link) {
        this.links.add(link);
        return this;
    }

    public NotificationBuilder exception(Throwable exception) {
        this.exceptionInfo = new NotificationExceptionInfo(exception);
        return this;
    }

    public NotificationBuilder exception(NotificationExceptionInfo exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
        return this;
    }

    public NotificationBuilder attach(String name, String contentType, byte[] content) {
        this.attachments.add(new NotificationAttachment(name, contentType, content));
        return this;
    }

    public NotificationBuilder attach(String name, String contentType, InputStream inputStream) {
        this.attachments.add(new NotificationAttachment(name, contentType, inputStream));
        return this;
    }

    public NotificationBuilder attach(String name, String contentType, String content) {
        this.attachments.add(new NotificationAttachment(name, contentType, content));
        return this;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public String getSummary() {
        return this.summary;
    }

    public NotificationExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public List<NotificationTrait> getTraits() {
        return this.traits;
    }

    public List<NotificationAttachment> getAttachments() {
        return this.attachments;
    }
}

