/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.send;

import java.io.PrintWriter;
import java.io.StringWriter;

public final class NotificationExceptionInfo {
    private final String exceptionType;
    private final String message;
    private final String stackTrace;
    private final NotificationExceptionInfo cause;

    public NotificationExceptionInfo(Throwable t) {
        if (t != null) {
            this.exceptionType = t.getClass().getName();
            this.message = t.getMessage();
            this.stackTrace = NotificationExceptionInfo.getStackTrace(t);
            this.cause = t.getCause() != null ? new NotificationExceptionInfo(t.getCause()) : null;
        } else {
            this.exceptionType = "undefined";
            this.message = "none";
            this.stackTrace = "none";
            this.cause = null;
        }
    }

    public NotificationExceptionInfo(String exceptionType, String message, String stackTrace, NotificationExceptionInfo cause) {
        this.exceptionType = exceptionType != null ? exceptionType : "undefined";
        this.message = message != null ? message : "none";
        this.stackTrace = stackTrace != null ? stackTrace : "none";
        this.cause = cause;
    }

    public static String getStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        return writer.toString().replace("\r", "");
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public NotificationExceptionInfo getCause() {
        return this.cause;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationExceptionInfo that = (NotificationExceptionInfo)o;
        if (this.cause != null ? !this.cause.equals(that.cause) : that.cause != null) {
            return false;
        }
        if (!this.exceptionType.equals(that.exceptionType)) {
            return false;
        }
        if (!this.message.equals(that.message)) {
            return false;
        }
        return this.stackTrace.equals(that.stackTrace);
    }

    public int hashCode() {
        int result = this.exceptionType.hashCode();
        result = 31 * result + this.message.hashCode();
        result = 31 * result + this.stackTrace.hashCode();
        result = 31 * result + (this.cause != null ? this.cause.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ExceptionInfo{exceptionType='" + this.exceptionType + '\'' + ", message='" + this.message + '\'' + ", stackTrace=" + this.stackTrace + ", cause=" + this.cause + '}';
    }
}

