@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  tioga-notify-server-grizzly startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and TIOGA_NOTIFY_SERVER_GRIZZLY_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\jersey-media-multipart-2.22.2.jar;%APP_HOME%\lib\jersey-container-grizzly2-http-2.22.2.jar;%APP_HOME%\lib\tioga-couchace-jackson-1.6.3.jar;%APP_HOME%\lib\jersey-spring3-2.22.2.jar;%APP_HOME%\lib\javax.servlet-api-3.1.0.jar;%APP_HOME%\lib\tioga-notify-server-grizzly-4.4.5.jar;%APP_HOME%\lib\spring-expression-4.3.2.RELEASE.jar;%APP_HOME%\lib\tioga-notify-jackson-5.1.4.jar;%APP_HOME%\lib\tioga-notify-engine-4.4.5.jar;%APP_HOME%\lib\classmate-1.0.0.jar;%APP_HOME%\lib\tioga-notify-processor-slack-4.4.5.jar;%APP_HOME%\lib\tioga-couchace-core-1.6.3.jar;%APP_HOME%\lib\bean-validator-2.4.0-b34.jar;%APP_HOME%\lib\commons-logging-1.2.jar;%APP_HOME%\lib\tioga-lib-pub-1.0.2.DEPRECATED.jar;%APP_HOME%\lib\hk2-utils-2.4.0-b34.jar;%APP_HOME%\lib\thymeleaf-extras-java8time-2.1.0.RELEASE.jar;%APP_HOME%\lib\hk2-config-2.4.0-b34.jar;%APP_HOME%\lib\jackson-core-2.5.1.jar;%APP_HOME%\lib\tiger-types-1.4.jar;%APP_HOME%\lib\tioga-notify-notifier-5.1.4.jar;%APP_HOME%\lib\javax.el-api-3.0.0.jar;%APP_HOME%\lib\javax.ws.rs-api-2.0.1.jar;%APP_HOME%\lib\tioga-couchace-annotations-1.6.3.jar;%APP_HOME%\lib\jersey-common-2.22.2.jar;%APP_HOME%\lib\tioga-dev-domain-4.2.9.jar;%APP_HOME%\lib\jersey-container-servlet-core-2.22.2.jar;%APP_HOME%\lib\tioga-push-client-6.0.1.jar;%APP_HOME%\lib\activation-1.1.jar;%APP_HOME%\lib\hk2-runlevel-2.4.0-b34.jar;%APP_HOME%\lib\jersey-guava-2.22.2.jar;%APP_HOME%\lib\validation-api-1.1.0.Final.jar;%APP_HOME%\lib\hk2-api-2.4.0-b34.jar;%APP_HOME%\lib\spring-core-4.3.2.RELEASE.jar;%APP_HOME%\lib\hk2-core-2.4.0-b34.jar;%APP_HOME%\lib\tioga-app-common-3.2.3.jar;%APP_HOME%\lib\asm-all-repackaged-2.4.0-b34.jar;%APP_HOME%\lib\config-types-2.4.0-b34.jar;%APP_HOME%\lib\javax.inject-2.4.0-b34.jar;%APP_HOME%\lib\unbescape-1.0.jar;%APP_HOME%\lib\spring-context-4.3.2.RELEASE.jar;%APP_HOME%\lib\tioga-lib-jaxrs-6.0.4.jar;%APP_HOME%\lib\grizzly-http-server-2.3.23.jar;%APP_HOME%\lib\tioga-notify-pub-5.1.4.jar;%APP_HOME%\lib\tioga-notify-processor-smtp-4.4.5.jar;%APP_HOME%\lib\jul-to-slf4j-1.7.20.jar;%APP_HOME%\lib\javax.inject-1.jar;%APP_HOME%\lib\logback-classic-1.1.7.jar;%APP_HOME%\lib\tioga-notify-processor-logger-4.4.5.jar;%APP_HOME%\lib\tioga-notify-sender-couch-5.1.4.jar;%APP_HOME%\lib\hk2-locator-2.4.0-b34.jar;%APP_HOME%\lib\javax.annotation-api-1.2.jar;%APP_HOME%\lib\aopalliance-repackaged-2.4.0-b34.jar;%APP_HOME%\lib\grizzly-http-2.3.23.jar;%APP_HOME%\lib\jboss-logging-3.1.3.GA.jar;%APP_HOME%\lib\tioga-lib-hal-1.0.3.jar;%APP_HOME%\lib\tioga-lib-thymeleaf-1.1.6.jar;%APP_HOME%\lib\spring-bridge-2.4.0-b34.jar;%APP_HOME%\lib\jackson-annotations-2.5.0.jar;%APP_HOME%\lib\jersey-server-2.22.2.jar;%APP_HOME%\lib\tioga-dev-jackson-4.2.9.jar;%APP_HOME%\lib\mimepull-1.9.6.jar;%APP_HOME%\lib\jackson-databind-2.5.1.jar;%APP_HOME%\lib\javassist-3.18.1-GA.jar;%APP_HOME%\lib\spring-web-3.2.3.RELEASE.jar;%APP_HOME%\lib\slf4j-api-1.7.20.jar;%APP_HOME%\lib\javax.el-3.0.0.jar;%APP_HOME%\lib\tioga-runners-grizzly-2.2.2.jar;%APP_HOME%\lib\tioga-notify-kernel-4.4.5.jar;%APP_HOME%\lib\grizzly-framework-2.3.23.jar;%APP_HOME%\lib\jersey-media-jaxb-2.22.2.jar;%APP_HOME%\lib\aopalliance-1.0.jar;%APP_HOME%\lib\spring-beans-4.3.2.RELEASE.jar;%APP_HOME%\lib\tioga-notify-processor-push-4.4.5.jar;%APP_HOME%\lib\log4j-over-slf4j-1.7.20.jar;%APP_HOME%\lib\tioga-lib-spring-1.2.4.jar;%APP_HOME%\lib\tioga-dev-common-5.2.6.jar;%APP_HOME%\lib\tioga-couchace-jersey-1.6.3.jar;%APP_HOME%\lib\logback-core-1.1.7.jar;%APP_HOME%\lib\spring-aop-4.3.2.RELEASE.jar;%APP_HOME%\lib\osgi-resource-locator-1.0.1.jar;%APP_HOME%\lib\tioga-notify-processor-swing-4.4.5.jar;%APP_HOME%\lib\class-model-2.4.0-b34.jar;%APP_HOME%\lib\jersey-client-2.22.2.jar;%APP_HOME%\lib\mail-1.5.0-b01.jar;%APP_HOME%\lib\hibernate-validator-5.1.3.Final.jar;%APP_HOME%\lib\jackson-datatype-jsr310-2.5.2.jar;%APP_HOME%\lib\hk2-2.4.0-b34.jar;%APP_HOME%\lib\thymeleaf-2.1.3.RELEASE.jar;%APP_HOME%\lib\aspectjweaver-1.8.5.jar;%APP_HOME%\lib\ognl-3.0.6.jar

@rem Execute tioga-notify-server-grizzly
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %TIOGA_NOTIFY_SERVER_GRIZZLY_OPTS%  -classpath "%CLASSPATH%" org.tiogasolutions.notify.server.grizzly.NotifyServer %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable TIOGA_NOTIFY_SERVER_GRIZZLY_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%TIOGA_NOTIFY_SERVER_GRIZZLY_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
