/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.operator;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.CustomResource;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.Objects;
import org.eclipse.microprofile.config.ConfigProvider;

@RegisterForReflection
public class OperatorUtils {
    public static <S, T> boolean shouldProcessAdd(CustomResource<S, T> resource) {
        return resource.getSpec() != null;
    }

    public static <S, T> boolean shouldProcessUpdate(CustomResource<S, T> newResource, CustomResource<S, T> oldResource) {
        if (newResource.getSpec() == null) {
            return false;
        }
        if (newResource.getMetadata() == null || oldResource.getMetadata() == null) {
            return false;
        }
        if (OperatorUtils.touchAnnotationChanged(newResource.getMetadata(), oldResource.getMetadata())) {
            return true;
        }
        return !Objects.equals(newResource.getMetadata().getGeneration(), oldResource.getMetadata().getGeneration());
    }

    private static boolean touchAnnotationChanged(ObjectMeta newResource, ObjectMeta oldResource) {
        String touchAnnotation = ConfigProvider.getConfig().getOptionalValue("onecx.operator.touch-annotation", String.class).orElse("org.tkit.onecx.touchedAt");
        return !Objects.equals(OperatorUtils.getTouchAnnotation(newResource, touchAnnotation), OperatorUtils.getTouchAnnotation(oldResource, touchAnnotation));
    }

    private static String getTouchAnnotation(ObjectMeta resource, String annotation) {
        if (resource.getAnnotations() == null) {
            return null;
        }
        return (String)resource.getAnnotations().get(annotation);
    }
}

