package gen.org.tkit.onecx.parameters.v1.api;

import gen.org.tkit.onecx.parameters.v1.model.ParametersBucket;
import gen.org.tkit.onecx.parameters.v1.model.ProblemDetailResponse;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import jakarta.enterprise.context.ApplicationScoped;

import io.quarkiverse.openapi.generator.annotations.GeneratedClass;
import io.quarkiverse.openapi.generator.annotations.GeneratedMethod;
import io.quarkiverse.openapi.generator.annotations.GeneratedParam;

/**
  * onecx-parameters v1
  * <p>No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)</p>
  */
@Path("/v1/{productName}/{appId}")
@RegisterRestClient(baseUri="http://onecx-parameter/", configKey="onecx_parameter")
@GeneratedClass(value="onecx-parameter-v1.yaml", tag = "Parameter")
@ApplicationScoped
@org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders(org.tkit.onecx.quarkus.parameters.client.HeadersFactory.class)
public interface ParameterV1Api {

     /**
     * Create history bucket request
     *
     * @param productName 
     * @param appId 
     * @param parametersBucket 
     */
    @POST
    @Path("/history")
    @Consumes({"application/json"})
    @Produces({"application/json"})
    @GeneratedMethod ("bucketRequest")
    public jakarta.ws.rs.core.Response bucketRequest(
        @GeneratedParam("productName") @PathParam("productName")String productName, 
        @GeneratedParam("appId") @PathParam("appId")String appId, 
        ParametersBucket parametersBucket
    );

     /**
     * Get parameters by application id
     *
     * @param productName 
     * @param appId 
     */
    @GET
    @Path("/parameters")
    @Produces({"application/json"})
    @GeneratedMethod ("getParameters")
    public jakarta.ws.rs.core.Response getParameters(
        @GeneratedParam("productName") @PathParam("productName")String productName, 
        @GeneratedParam("appId") @PathParam("appId")String appId
    );

}