package gen.org.tkit.onecx.parameters.v1.model;


import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import gen.org.tkit.onecx.parameters.v1.model.ParameterInfo;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import com.fasterxml.jackson.annotation.JsonProperty;

@io.quarkus.runtime.annotations.RegisterForReflection
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)
public class ParametersBucket  {

    private Map<String, ParameterInfo> parameters;
    private String instanceId;
    private OffsetDateTime start;
    private OffsetDateTime end;

    /**
    * Get parameters
    * @return parameters
    **/
    @JsonProperty("parameters")
    @com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
    public Map<String, ParameterInfo> getParameters() {
        return parameters;
    }

    /**
     * Set parameters
     **/
    public void setParameters(Map<String, ParameterInfo> parameters) {
        this.parameters = parameters;
    }

    public ParametersBucket parameters(Map<String, ParameterInfo> parameters) {
        this.parameters = parameters;
        return this;
    }
    public ParametersBucket putParametersItem(String mapKey, ParameterInfo parametersItem) {
           if (this.parameters == null){
                parameters = new HashMap<>();
            }
        this.parameters.put(mapKey, parametersItem);
        return this;
    }

    /**
    * Get instanceId
    * @return instanceId
    **/
    @JsonProperty("instanceId")
    @com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
    public String getInstanceId() {
        return instanceId;
    }

    /**
     * Set instanceId
     **/
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public ParametersBucket instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    /**
    * Get start
    * @return start
    **/
    @JsonProperty("start")
    @com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
    public OffsetDateTime getStart() {
        return start;
    }

    /**
     * Set start
     **/
    public void setStart(OffsetDateTime start) {
        this.start = start;
    }

    public ParametersBucket start(OffsetDateTime start) {
        this.start = start;
        return this;
    }

    /**
    * Get end
    * @return end
    **/
    @JsonProperty("end")
    @com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
    public OffsetDateTime getEnd() {
        return end;
    }

    /**
     * Set end
     **/
    public void setEnd(OffsetDateTime end) {
        this.end = end;
    }

    public ParametersBucket end(OffsetDateTime end) {
        this.end = end;
        return this;
    }

    /**
     * Create a string representation of this pojo.
     **/
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParametersBucket {\n");

        sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
        sb.append("    instanceId: ").append(toIndentedString(instanceId)).append("\n");
        sb.append("    start: ").append(toIndentedString(start)).append("\n");
        sb.append("    end: ").append(toIndentedString(end)).append("\n");
        
        sb.append("}");
        return sb.toString();
    }

    /**
     * Compares this object to the specified object. The result is
     * {@code true} if and only if the argument is not
     * {@code null} and is a {@code ParametersBucket} object that
     * contains the same values as this object.
     *
     * @param   obj   the object to compare with.
     * @return  {@code true} if the objects are the same;
     *          {@code false} otherwise.
     **/
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;

        ParametersBucket model = (ParametersBucket) obj;

        return java.util.Objects.equals(parameters, model.parameters) &&
        java.util.Objects.equals(instanceId, model.instanceId) &&
        java.util.Objects.equals(start, model.start) &&
        java.util.Objects.equals(end, model.end);
    }

    /**
     * Returns a hash code for a {@code ParametersBucket}.
     *
     * @return a hash code value for a {@code ParametersBucket}.
     **/
    @Override
    public int hashCode() {
        return java.util.Objects.hash(parameters,
        instanceId,
        start,
        end);
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)
@io.quarkus.runtime.annotations.RegisterForReflection
    public static class ParametersBucketQueryParam  {

        @jakarta.ws.rs.QueryParam("parameters")
        private Map<String, ParameterInfo> parameters = null;
        @jakarta.ws.rs.QueryParam("instanceId")
        private String instanceId;
        @jakarta.ws.rs.QueryParam("start")
        private OffsetDateTime start;
        @jakarta.ws.rs.QueryParam("end")
        private OffsetDateTime end;

        /**
        * Get parameters
        * @return parameters
        **/
        @com.fasterxml.jackson.annotation.JsonProperty("parameters")
        public Map<String, ParameterInfo> getParameters() {
            return parameters;
        }

        /**
         * Set parameters
         **/
        public void setParameters(Map<String, ParameterInfo> parameters) {
            this.parameters = parameters;
        }

        public ParametersBucketQueryParam parameters(Map<String, ParameterInfo> parameters) {
            this.parameters = parameters;
            return this;
        }
        public ParametersBucketQueryParam putParametersItem(String mapKey, ParameterInfo parametersItem) {
            this.parameters.put(mapKey, parametersItem);
            return this;
        }

        /**
        * Get instanceId
        * @return instanceId
        **/
        @com.fasterxml.jackson.annotation.JsonProperty("instanceId")
        public String getInstanceId() {
            return instanceId;
        }

        /**
         * Set instanceId
         **/
        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public ParametersBucketQueryParam instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
        * Get start
        * @return start
        **/
        @com.fasterxml.jackson.annotation.JsonProperty("start")
        public OffsetDateTime getStart() {
            return start;
        }

        /**
         * Set start
         **/
        public void setStart(OffsetDateTime start) {
            this.start = start;
        }

        public ParametersBucketQueryParam start(OffsetDateTime start) {
            this.start = start;
            return this;
        }

        /**
        * Get end
        * @return end
        **/
        @com.fasterxml.jackson.annotation.JsonProperty("end")
        public OffsetDateTime getEnd() {
            return end;
        }

        /**
         * Set end
         **/
        public void setEnd(OffsetDateTime end) {
            this.end = end;
        }

        public ParametersBucketQueryParam end(OffsetDateTime end) {
            this.end = end;
            return this;
        }

        /**
         * Create a string representation of this pojo.
         **/
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class ParametersBucketQueryParam {\n");

            sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
            sb.append("    instanceId: ").append(toIndentedString(instanceId)).append("\n");
            sb.append("    start: ").append(toIndentedString(start)).append("\n");
            sb.append("    end: ").append(toIndentedString(end)).append("\n");
            sb.append("}");
            return sb.toString();
        }

        /**
         * Convert the given object to string with each line indented by 4 spaces
         * (except the first line).
         */
        private static String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }}
