/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter.deployment.devservices;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;
import org.tkit.onecx.quarkus.parameter.deployment.ParametersBuildTimeConfig;
import org.tkit.onecx.quarkus.parameter.deployment.devservices.ContainerShutdownCloseable;
import org.tkit.onecx.quarkus.parameter.deployment.devservices.DevServicesConfig;
import org.tkit.onecx.quarkus.parameter.deployment.devservices.ParametersDbDevServicesProviderBuildItem;

public class ParametersDbDevServicesProcessor {
    private static final Logger log = LoggerFactory.getLogger(ParametersDbDevServicesProcessor.class);
    static volatile ParametersDbRunningDevService devService;
    static volatile ParametersDbDevServiceCfg cfg;
    static volatile boolean first;
    public static final String DB_FEATURE_NAME = "onecx-parameters-db";
    private static final String DB_ALIAS = "onecx-parameters-db";
    private static final String DEV_SERVICE_LABEL = "onecx-dev-service-parameters-db";
    public static final int DEFAULT_PORT = 5432;
    private static final ContainerLocator containerLocator;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public DevServicesResultBuildItem startDbContainers(LaunchModeBuildItem launchMode, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, ParametersBuildTimeConfig buildTimeConfig, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, BuildProducer<ParametersDbDevServicesProviderBuildItem> startResultProducer, CuratedApplicationShutdownBuildItem closeBuildItem, DockerStatusBuildItem dockerStatusBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        ParametersDbDevServiceCfg configuration = this.getConfiguration(buildTimeConfig);
        if (devService != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !configuration.equals(cfg);
            if (!shouldShutdownTheBroker) {
                return devService.toBuildItem();
            }
            this.stopContainer();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Parameters Database Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            devService = this.startContainer(dockerStatusBuildItem, configuration, launchMode, !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.stopContainer();
                }
                first = true;
                devService = null;
                cfg = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        if (devService.isOwner()) {
            log.info("The Parameters database is ready to accept connections. Config: {}", (Object)devService.getJdbcUrl());
            startResultProducer.produce((BuildItem)new ParametersDbDevServicesProviderBuildItem(devService.getJdbcUrl(), devService.getDbUsername(), devService.getDbPassword()));
        }
        return devService.toBuildItem();
    }

    private ParametersDbRunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, ParametersDbDevServiceCfg config, LaunchModeBuildItem launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        if (!config.devServicesEnabled) {
            log.debug("Not starting dev services for Parameters as it has been disabled in the config");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn("Docker isn't working, please configure the Parameters URL property ({}).", (Object)"quarkus.rest-client.onecx-parameters.url");
            return null;
        }
        Optional maybeContainerAddress = containerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode());
        Supplier<ParametersDbRunningDevService> defaultSupplier = () -> {
            ParametersPostgreSQLContainer container = new ParametersPostgreSQLContainer(config.imageName, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null, useSharedNetwork);
            timeout.ifPresent(arg_0 -> ((ParametersPostgreSQLContainer)container).withStartupTimeout(arg_0));
            if (config.reuse) {
                container.withReuse(true);
            }
            container.start();
            return new ParametersDbRunningDevService("onecx-parameters-db", container.getContainerId(), new ContainerShutdownCloseable((GenericContainer<?>)container, "onecx-parameters-db"), container.getJdbcUrl(), container.getUsername(), container.getPassword());
        };
        return maybeContainerAddress.map(containerAddress -> new ParametersDbRunningDevService("onecx-parameters-db", containerAddress.getId(), null)).orElseGet(defaultSupplier);
    }

    private ParametersDbDevServiceCfg getConfiguration(ParametersBuildTimeConfig cfg) {
        DevServicesConfig devServicesConfig = cfg.devServices();
        return new ParametersDbDevServiceCfg(devServicesConfig);
    }

    private void stopContainer() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error("Failed to stop the Parameters database", e);
            }
            finally {
                devService = null;
            }
        }
    }

    static {
        first = true;
        containerLocator = new ContainerLocator(DEV_SERVICE_LABEL, 5432);
    }

    private static final class ParametersDbDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final boolean shared;
        private final String serviceName;
        private final boolean reuse;

        public ParametersDbDevServiceCfg(DevServicesConfig config) {
            this.devServicesEnabled = config.enabled();
            DevServicesConfig.ParametersDatabaseConfig tmp = config.db();
            this.imageName = tmp.imageName();
            this.serviceName = tmp.serviceName();
            this.shared = config.shared();
            this.reuse = config.reuse();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParametersDbDevServiceCfg that = (ParametersDbDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName);
        }
    }

    public static class ParametersDbRunningDevService
    extends DevServicesResultBuildItem.RunningDevService {
        private final String dbUsername;
        private final String dbPassword;
        private final String jdbcUrl;

        public ParametersDbRunningDevService(String name, String containerId, Closeable closeable) {
            super(name, containerId, closeable, Map.of());
            this.jdbcUrl = null;
            this.dbPassword = null;
            this.dbUsername = null;
        }

        public ParametersDbRunningDevService(String name, String containerId, Closeable closeable, String jdbcUrl, String dbUsername, String dbPassword) {
            super(name, containerId, closeable, Map.of());
            this.jdbcUrl = jdbcUrl;
            this.dbUsername = dbUsername;
            this.dbPassword = dbPassword;
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }

        public String getDbPassword() {
            return this.dbPassword;
        }

        public String getDbUsername() {
            return this.dbUsername;
        }
    }

    private static class ParametersPostgreSQLContainer
    extends PostgreSQLContainer<ParametersPostgreSQLContainer> {
        private final boolean useSharedNetwork;
        private String hostName = null;

        public ParametersPostgreSQLContainer(String imageName, String serviceName, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName).asCompatibleSubstituteFor(DockerImageName.parse((String)"postgres")));
            log.debug("Parameters database docker image {}", (Object)imageName);
            this.useSharedNetwork = useSharedNetwork;
            if (serviceName != null) {
                this.withLabel(ParametersDbDevServicesProcessor.DEV_SERVICE_LABEL, serviceName);
            }
            this.addExposedPort(POSTGRESQL_PORT);
            this.hostName = "onecx-parameters-db";
            this.withNetworkAliases(new String[]{"onecx-parameters-db"});
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"onecx-parameters-db");
            } else {
                this.withNetwork(Network.SHARED);
            }
        }

        public String getJdbcUrl() {
            String additionalUrlParams = this.constructUrlParameters("?", "&");
            return "jdbc:postgresql://" + this.hostName + ":" + POSTGRESQL_PORT + "/" + this.getDatabaseName() + additionalUrlParams;
        }
    }
}

