/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter.deployment.devservices;

import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.tkit.onecx.quarkus.parameter.deployment.ParametersBuildTimeConfig;
import org.tkit.onecx.quarkus.parameter.deployment.devservices.ContainerLogger;
import org.tkit.onecx.quarkus.parameter.deployment.devservices.ContainerShutdownCloseable;
import org.tkit.onecx.quarkus.parameter.deployment.devservices.DevServicesConfig;
import org.tkit.onecx.quarkus.parameter.deployment.devservices.ParametersDbDevServicesProviderBuildItem;

public class ParametersDevServicesProcessor {
    private static final Logger log = LoggerFactory.getLogger(ParametersDevServicesProcessor.class);
    private static final String DEFAULT_DOCKER_IMAGE = "ghcr.io/onecx/onecx-parameter-svc:main";
    private static final String DEV_SERVICE_LABEL = "onecx-dev-service-parameters";
    private static final String IMPORT_FILE_PATH = "/tmp/parameters-import-file.json";
    public static final int DEFAULT_PORT = 8080;
    private static final ContainerLocator containerLocator = new ContainerLocator("onecx-dev-service-parameters", 8080);
    static volatile ParametersRunningDevService devService;
    static volatile ParametersDevServiceCfg cfg;
    static volatile boolean first;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public DevServicesResultBuildItem startContainers(LaunchModeBuildItem launchMode, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, ParametersBuildTimeConfig buildTimeConfig, ParametersDbDevServicesProviderBuildItem dbSettings, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, DockerStatusBuildItem dockerStatusBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        ParametersDevServiceCfg configuration = this.getConfiguration(buildTimeConfig);
        if (devService != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !configuration.equals(cfg);
            if (!shouldShutdownTheBroker) {
                return devService.toBuildItem();
            }
            this.stopContainer();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Parameters Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            devService = this.startContainer(dockerStatusBuildItem, configuration, dbSettings, launchMode, !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.stopContainer();
                }
                first = true;
                devService = null;
                cfg = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        if (devService.isOwner()) {
            String tmp = (String)devService.getConfig().get("quarkus.rest-client.onecx-parameters.url");
            log.info("The parameters is ready to accept connections on {}", (Object)tmp);
        }
        return devService.toBuildItem();
    }

    private ParametersRunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, ParametersDevServiceCfg config, ParametersDbDevServicesProviderBuildItem dbSettings, LaunchModeBuildItem launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        if (!config.devServicesEnabled) {
            log.debug("Not starting dev services for Parameters as it has been disabled in the config");
            return null;
        }
        if (ConfigUtils.isPropertyPresent((String)"quarkus.rest-client.onecx-parameters.url")) {
            log.debug("Not starting dev services for Parameters as '{}' have been provided", (Object)"quarkus.rest-client.onecx-parameters.url");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn("Docker isn't working, please configure the Parameters URL property ({}).", (Object)"quarkus.rest-client.onecx-parameters.url");
            return null;
        }
        Optional maybeContainerAddress = containerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode());
        Supplier<ParametersRunningDevService> defaultParametersSupplier = () -> {
            DockerImageName image = DockerImageName.parse((String)config.imageName);
            ParametersContainer container = new ParametersContainer(image, config.fixedExposedPort, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null, useSharedNetwork, config.importFile, dbSettings);
            timeout.ifPresent(arg_0 -> ((ParametersContainer)container).withStartupTimeout(arg_0));
            if (config.log) {
                container.withLogConsumer((Consumer)((Object)ContainerLogger.create(config.serviceName)));
            }
            if (config.reuse) {
                container.withReuse(true);
            }
            container.start();
            return new ParametersRunningDevService("onecx-parameters", container.getContainerId(), new ContainerShutdownCloseable(container, "onecx-parameters"), ParametersDevServicesProcessor.configMap(container.getUrl()));
        };
        return maybeContainerAddress.map(containerAddress -> new ParametersRunningDevService("onecx-parameters", containerAddress.getId(), null, ParametersDevServicesProcessor.configMap(containerAddress.getUrl()))).orElseGet(defaultParametersSupplier);
    }

    private static Map<String, String> configMap(String url) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("quarkus.rest-client.onecx-parameters.url", url);
        return config;
    }

    private ParametersDevServiceCfg getConfiguration(ParametersBuildTimeConfig cfg) {
        DevServicesConfig devServicesConfig = cfg.devServices();
        return new ParametersDevServiceCfg(devServicesConfig);
    }

    private void stopContainer() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error("Failed to stop the Parameters service", e);
            }
            finally {
                devService = null;
            }
        }
    }

    static {
        first = true;
    }

    private static final class ParametersDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final Integer fixedExposedPort;
        private final boolean shared;
        private final String serviceName;
        private final String importFile;
        private final boolean reuse;
        private final boolean log;

        public ParametersDevServiceCfg(DevServicesConfig config) {
            this.devServicesEnabled = config.enabled();
            this.imageName = config.imageName().orElse(ParametersDevServicesProcessor.DEFAULT_DOCKER_IMAGE);
            this.fixedExposedPort = config.port().orElse(0);
            this.shared = config.shared();
            this.serviceName = config.serviceName();
            this.reuse = config.reuse();
            this.importFile = config.importFile().orElse(null);
            this.log = config.log();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParametersDevServiceCfg that = (ParametersDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort);
        }
    }

    public static class ParametersRunningDevService
    extends DevServicesResultBuildItem.RunningDevService {
        public ParametersRunningDevService(String name, String containerId, Closeable closeable, Map<String, String> config) {
            super(name, containerId, closeable, config);
        }
    }

    private static class ParametersContainer
    extends GenericContainer<ParametersContainer> {
        private final boolean useSharedNetwork;
        private final int fixedExposedPort;
        private String hostName = null;

        public ParametersContainer(DockerImageName image, int fixedExposedPort, String serviceName, boolean useSharedNetwork, String importFile, ParametersDbDevServicesProviderBuildItem dbSettings) {
            super(image);
            log.debug("Parameters docker image {}", (Object)image);
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            this.withExposedPorts(new Integer[]{8080});
            this.withEnv("_PROD_TKIT_LOG_JSON_ENABLED", "false");
            ((ParametersContainer)((ParametersContainer)this.withEnv("_PROD_QUARKUS_DATASOURCE_JDBC_URL", dbSettings.getJdbcUrl())).withEnv("_PROD_QUARKUS_DATASOURCE_USERNAME", dbSettings.getUsername())).withEnv("_PROD_QUARKUS_DATASOURCE_PASSWORD", dbSettings.getPassword());
            if (serviceName != null) {
                this.withLabel(ParametersDevServicesProcessor.DEV_SERVICE_LABEL, serviceName);
            }
            if (importFile != null) {
                this.withEnv("TKIT_DATAIMPORT_ENABLED", "true");
                this.withEnv("TKIT_DATAIMPORT_CONFIGURATIONS_PARAMETERS_ENABLED", "true");
                this.withEnv("TKIT_DATAIMPORT_CONFIGURATIONS_PARAMETERS_FILE", ParametersDevServicesProcessor.IMPORT_FILE_PATH);
                this.withEnv("TKIT_DATAIMPORT_CONFIGURATIONS_PARAMETERS_METADATA_OPERATION", "CLEAN_INSERT");
                if (Files.isRegularFile(Path.of(importFile, new String[0]), new LinkOption[0])) {
                    log.info("Parameters startup import regular file: {}", (Object)importFile);
                    this.withFileSystemBind(importFile, ParametersDevServicesProcessor.IMPORT_FILE_PATH, BindMode.READ_ONLY);
                } else {
                    log.info("Parameters startup import class-path file: {}", (Object)importFile);
                    this.withClasspathResourceMapping(importFile, ParametersDevServicesProcessor.IMPORT_FILE_PATH, BindMode.READ_ONLY);
                }
            }
            this.waitingFor((WaitStrategy)Wait.forHttp((String)"/q/health"));
        }

        public String getExternalAddress(int port) {
            return this.getHost() + ":" + this.getMappedPort(port);
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"parameters");
                return;
            }
            this.withNetwork(Network.SHARED);
            if (this.fixedExposedPort > 0) {
                this.addFixedExposedPort(this.fixedExposedPort, 8080);
            } else {
                this.addExposedPort(8080);
            }
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 8080;
            }
            if (this.fixedExposedPort > 0) {
                return this.fixedExposedPort;
            }
            return super.getFirstMappedPort();
        }

        public String getInternalAddress(int port) {
            return this.getInternalHost() + ":" + port;
        }

        @API(status=API.Status.EXPERIMENTAL)
        public String getInternalHost() {
            GenericContainer container = (GenericContainer)this.self();
            List aliases = container.getNetworkAliases();
            if (aliases.isEmpty()) {
                return container.getContainerInfo().getName();
            }
            return (String)aliases.get(aliases.size() - 1);
        }

        public String getParametersHost() {
            return this.useSharedNetwork ? this.hostName : super.getHost();
        }

        public String getUrl() {
            return String.format("http://%s:%d/", this.getParametersHost(), this.getPort());
        }
    }
}

