/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter.deployment.devservices;

import java.io.Closeable;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.TestcontainersConfiguration;

public class ContainerShutdownCloseable
implements Closeable {
    private static final Logger LOG = Logger.getLogger(ContainerShutdownCloseable.class);
    private final GenericContainer<?> container;
    private final String friendlyServiceName;

    public ContainerShutdownCloseable(GenericContainer<?> container, String friendlyServiceName) {
        Objects.requireNonNull(container);
        Objects.requireNonNull(friendlyServiceName);
        this.container = container;
        this.friendlyServiceName = friendlyServiceName;
    }

    @Override
    public void close() {
        if (TestcontainersConfiguration.getInstance().environmentSupportsReuse() && this.container.isShouldBeReused()) {
            LOG.infof("Dev Services for %s is no longer needed by this Quarkus instance, but is not shut down as 'testcontainers.reuse.enable' is enabled in your Testcontainers configuration file", (Object)this.friendlyServiceName);
        } else {
            this.container.stop();
            LOG.infof("Dev Services for %s shut down.", (Object)this.friendlyServiceName);
        }
    }
}

