/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.tkit.onecx.quarkus.parameter.Parameter;
import org.tkit.onecx.quarkus.parameter.ParametersService;
import org.tkit.onecx.quarkus.parameter.config.ParametersBuildTimeConfig;
import org.tkit.onecx.quarkus.parameter.config.ParametersConfig;
import org.tkit.onecx.quarkus.parameter.deployment.EmptyAnnotationNameException;
import org.tkit.onecx.quarkus.parameter.metrics.MicrometerMetricsRecorder;
import org.tkit.onecx.quarkus.parameter.metrics.NoopMetricsRecorder;
import org.tkit.onecx.quarkus.parameter.runtime.AbstractParameterProducer;
import org.tkit.onecx.quarkus.parameter.runtime.ParametersRecorder;

public class ParametersProcessor {
    public static final DotName DN_PARAMETER = DotName.createSimple(Parameter.class);
    public static final String FEATURE = "onecx-parameters";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void configure(BeanContainerBuildItem beanContainer, ParametersRecorder recorder, ParametersConfig config) {
        BeanContainer container = beanContainer.getValue();
        recorder.configSources(container, config);
    }

    @BuildStep
    void addMetrics(ParametersBuildTimeConfig config, Optional<MetricsCapabilityBuildItem> metricsCapability, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        boolean withMicrometer;
        if (!config.metrics().enabled()) {
            return;
        }
        if (metricsCapability.isPresent() && (withMicrometer = metricsCapability.map(cap -> cap.metricsSupported("micrometer")).orElse(false).booleanValue())) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem.Builder().addBeanClass(MicrometerMetricsRecorder.class).setDefaultScope(BuiltinScope.APPLICATION.getName()).setUnremovable().build());
            return;
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(NoopMetricsRecorder.class));
    }

    @BuildStep
    void validateAnnotations(CombinedIndexBuildItem combinedIndex, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        ArrayList<EmptyAnnotationNameException> errors = new ArrayList<EmptyAnnotationNameException>();
        for (AnnotationInstance annotation : combinedIndex.getIndex().getAnnotations(DN_PARAMETER)) {
            AnnotationTarget target = annotation.target();
            String name = annotation.value("name").asString();
            switch (target.kind()) {
                case FIELD: {
                    if (name != null && !name.isEmpty()) break;
                    ClassInfo declaringClass = target.asField().declaringClass();
                    errors.add(new EmptyAnnotationNameException(declaringClass));
                    break;
                }
                case METHOD_PARAMETER: {
                    if (name != null && !name.isEmpty()) break;
                    ClassInfo declaringClass = target.asMethodParameter().method().declaringClass();
                    errors.add(new EmptyAnnotationNameException(declaringClass));
                    break;
                }
            }
        }
        validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(errors.toArray(new Throwable[0])));
    }

    @BuildStep
    void generateProducer(CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedBeanBuildItem> generatedBeans) {
        IndexView index = combinedIndex.getIndex();
        Collection ais = index.getAnnotations(DN_PARAMETER);
        HashSet<DotName> names = new HashSet<DotName>();
        block4: for (AnnotationInstance ano : ais) {
            Type type;
            switch (ano.target().kind()) {
                case FIELD: {
                    FieldInfo field = ano.target().asField();
                    type = field.type();
                    break;
                }
                case METHOD_PARAMETER: {
                    MethodParameterInfo methodParameter = ano.target().asMethodParameter();
                    type = methodParameter.type();
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ParameterizedType pt = type.asParameterizedType();
            Type vt = (Type)pt.arguments().get(0);
            names.add(vt.name());
        }
        if (!names.isEmpty()) {
            GeneratedBeanGizmoAdaptor beansClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
            ParametersProcessor.generateProducerClass((ClassOutput)beansClassOutput, names);
        }
    }

    static void generateProducerClass(ClassOutput classOutput, Set<DotName> names) {
        try (ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className("org.tkit.onecx.quarkus.parameter.runtime.ParameterProducer").superClass(AbstractParameterProducer.class.getName()).build();){
            FieldCreator service = (FieldCreator)classCreator.getFieldCreator("service", ParametersService.class.getName()).setModifiers(1);
            service.addAnnotation(Inject.class);
            for (DotName name : names) {
                String hash = "_" + HashUtil.sha1((String)name.toString());
                MethodCreator methodCreator = classCreator.getMethodCreator("produce" + name.withoutPackagePrefix() + hash, name.toString(), new String[]{InjectionPoint.class.getName()});
                try {
                    methodCreator.addAnnotation(Produces.class);
                    methodCreator.addAnnotation(Parameter.class).add("name", (Object)"ignored");
                    ResultHandle paramObj = methodCreator.readInstanceField(service.getFieldDescriptor(), methodCreator.getThis());
                    ResultHandle res = methodCreator.invokeSpecialMethod(MethodDescriptor.ofMethod(AbstractParameterProducer.class, (String)"getParameter", Object.class, (Class[])new Class[]{InjectionPoint.class, Class.class, ParametersService.class}), methodCreator.getThis(), new ResultHandle[]{methodCreator.getMethodParam(0), methodCreator.loadClass(name.toString()), paramObj});
                    methodCreator.returnValue(res);
                }
                finally {
                    if (methodCreator == null) continue;
                    methodCreator.close();
                }
            }
        }
    }
}

