/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter;

import io.quarkus.vertx.ConsumeEvent;
import io.vertx.core.Vertx;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.onecx.quarkus.parameter.ParameterEvent;
import org.tkit.onecx.quarkus.parameter.ParameterRestClient;
import org.tkit.onecx.quarkus.parameter.ParametersBucket;
import org.tkit.onecx.quarkus.parameter.ParametersConfig;

@Singleton
public class ParametersMetricsService {
    private static final Logger log = LoggerFactory.getLogger(ParametersMetricsService.class);
    @Inject
    @RestClient
    ParameterRestClient client;
    @Inject
    Vertx vertx;
    volatile ParametersBucket bucket;

    public void init(ParametersConfig parametersConfig, String applicationId) {
        this.bucket = new ParametersBucket();
        String instanceId = parametersConfig.instanceId.orElse(null);
        this.vertx.setPeriodic(parametersConfig.metrics.metricsIntervalInMilliseconds.longValue(), id -> {
            ParametersBucket tmp = this.bucket;
            this.bucket = new ParametersBucket();
            tmp.instanceId = instanceId;
            tmp.end();
            this.client.sendMetrics(applicationId, tmp).onItem().transform(resp -> {
                if (resp.getStatus() != 200) {
                    log.error("Error send metrics to the parameters management. Code: " + resp.getStatus());
                }
                return resp.getStatus();
            }).onFailure().recoverWithItem(ex -> {
                log.error("Error send metrics to the parameters management. Error: " + ex.getMessage());
                return -1;
            }).subscribe().with(r -> log.debug("Send metrics. Code: " + r));
        });
    }

    @ConsumeEvent(value="ParameterEvent")
    public void consumeEvent(ParameterEvent event) {
        this.bucket.addParameterRequest(event.propertyName, event.propertyType, event.defaultValue, event.currentValue);
    }
}

