/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import org.tkit.onecx.quarkus.parameter.ParametersBucket;

public class ParametersBucketHolder {
    private final ParametersBucket bucket = new ParametersBucket();

    public ParametersBucketHolder() {
        this.bucket.setStart(ParametersBucketHolder.now());
    }

    public void addParameterRequest(String name, Class<?> clazz, Object defaultValue, Object currentValue) {
        this.bucket.getParameters().computeIfAbsent(name, s -> new ParametersBucket.ParameterInfo(clazz, defaultValue, currentValue)).getCount().incrementAndGet();
    }

    public void setInstanceId(String instanceId) {
        this.bucket.setInstanceId(instanceId);
    }

    public void end() {
        this.bucket.setEnd(ParametersBucketHolder.now());
    }

    public ParametersBucket getBucket() {
        return this.bucket;
    }

    static OffsetDateTime now() {
        return OffsetDateTime.now(ZoneId.of("UTC"));
    }
}

