/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter;

import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.common.AbstractConfigSource;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.mutiny.core.eventbus.EventBus;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.onecx.quarkus.parameter.ParameterEvent;
import org.tkit.onecx.quarkus.parameter.ParameterRestClient;
import org.tkit.onecx.quarkus.parameter.ParametersConfig;

@ApplicationScoped
public class ParametersService {
    private static final Logger log = LoggerFactory.getLogger(ParametersService.class);
    static Map<String, String> data = new ConcurrentHashMap<String, String>();
    static ParametersConfigSource source = new ParametersConfigSource();
    @Inject
    @RestClient
    ParameterRestClient client;
    @Inject
    EventBus bus;
    @Inject
    Vertx vertx;
    SmallRyeConfig config;
    SmallRyeConfig quarkusConfig;
    boolean metrics;

    public void init(ParametersConfig parametersConfig, String applicationId) {
        this.metrics = parametersConfig.metrics().enabled();
        ConfigBuilder builder = ConfigProviderResolver.instance().getBuilder().addDiscoveredConverters().withSources(new ConfigSource[]{source});
        this.config = (SmallRyeConfig)builder.build();
        this.quarkusConfig = (SmallRyeConfig)ConfigProvider.getConfig();
        if (parametersConfig.updateAtStart()) {
            this.update(applicationId).subscribe().with(d -> log.info("Init parameters cache: {}", d));
        }
        this.vertx.setPeriodic(parametersConfig.updateIntervalInMilliseconds(), id -> this.update(applicationId).subscribe().with(d -> log.info("Update parameters cache: {}", d)));
    }

    Uni<Map<String, String>> update(String applicationId) {
        return this.client.getParameters(applicationId).onFailure().recoverWithItem(ex -> {
            log.error("Error updating the configuration from parameters management. Error: {}", (Object)ex.getMessage());
            return null;
        }).onItem().ifNotNull().invoke(m -> data.putAll((Map<String, String>)m));
    }

    public <T> T getValue(String propertyName, Class<T> propertyType, String defaultValue) {
        Optional value = this.config.getOptionalValue(propertyName, propertyType);
        if (value.isPresent()) {
            return this.sendMetrics(propertyName, propertyType, defaultValue, this.config.getRawValue(propertyName), value.get());
        }
        value = this.quarkusConfig.getOptionalValue(propertyName, propertyType);
        if (value.isPresent()) {
            return this.sendMetrics(propertyName, propertyType, defaultValue, this.quarkusConfig.getRawValue(propertyName), value.get());
        }
        if (defaultValue != null && !defaultValue.isBlank()) {
            return (T)this.sendMetrics(propertyName, propertyType, defaultValue, defaultValue, this.quarkusConfig.convert(defaultValue, propertyType));
        }
        return null;
    }

    private <T> T sendMetrics(String propertyName, Class<T> propertyType, String defaultValue, String rawValue, T currentValue) {
        if (this.metrics) {
            this.bus.send("ParameterEvent", (Object)ParameterEvent.of(propertyName, propertyType, defaultValue, rawValue));
        }
        return currentValue;
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        return this.getValue(propertyName, propertyType, null);
    }

    public static class ParametersConfigSource
    extends AbstractConfigSource {
        public ParametersConfigSource() {
            super("onecx-parameters-config-source", 999);
        }

        public Map<String, String> getProperties() {
            return data;
        }

        public Set<String> getPropertyNames() {
            return data.keySet();
        }

        public String getValue(String propertyName) {
            return data.get(propertyName);
        }
    }
}

