/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.ApplicationConfig;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.onecx.quarkus.parameter.ParametersConfig;
import org.tkit.onecx.quarkus.parameter.ParametersMetricsService;
import org.tkit.onecx.quarkus.parameter.ParametersService;

@Recorder
public class ParametersRecorder {
    static final String UNKNOWN_SERVICE_NAME = "quarkus/unknown";
    private static final Logger log = LoggerFactory.getLogger(ParametersRecorder.class);

    public void configSources(BeanContainer container, ApplicationConfig appConfig, ParametersConfig config) {
        if (!config.enabled()) {
            log.debug("No attempt will be made to obtain configuration from Parameters management because the functionality has been disabled via configuration");
            return;
        }
        String applicationId = config.applicationId().orElseGet(() -> appConfig.name.orElse(UNKNOWN_SERVICE_NAME));
        ParametersService service = (ParametersService)container.beanInstance(ParametersService.class, new Annotation[]{Default.Literal.INSTANCE});
        service.init(config, applicationId);
        if (config.metrics().enabled()) {
            ParametersMetricsService metrics = (ParametersMetricsService)container.beanInstance(ParametersMetricsService.class, new Annotation[]{Default.Literal.INSTANCE});
            metrics.init(config, applicationId);
        }
    }
}

