/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter.history;

import gen.org.tkit.onecx.parameters.v1.api.ParameterV1Api;
import gen.org.tkit.onecx.parameters.v1.model.ParameterInfo;
import gen.org.tkit.onecx.parameters.v1.model.ParametersBucket;
import io.quarkus.arc.Arc;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.Scheduler;
import io.quarkus.vertx.ConsumeEvent;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.onecx.quarkus.parameter.config.ParametersConfig;
import org.tkit.onecx.quarkus.parameter.history.ParametersHistory;
import org.tkit.onecx.quarkus.parameter.history.ParametersHistoryEvent;
import org.tkit.onecx.quarkus.parameter.metrics.MetricsRecorder;
import org.tkit.onecx.quarkus.parameter.tenant.TenantResolver;
import org.tkit.quarkus.context.ApplicationContext;
import org.tkit.quarkus.context.Context;

@Singleton
public class ParametersHistoryService {
    private static final Logger log = LoggerFactory.getLogger(ParametersHistoryService.class);
    @Inject
    Scheduler scheduler;
    @Inject
    @RestClient
    ParameterV1Api client;
    @Inject
    ParametersConfig config;
    @Inject
    TenantResolver resolver;
    MetricsRecorder metricsRecorder;
    private ParametersHistory history;
    private static String instanceId;
    private static boolean multiTenant;

    public void init(ParametersConfig parametersConfig) {
        this.metricsRecorder = (MetricsRecorder)Arc.container().instance(MetricsRecorder.class, new Annotation[0]).get();
        instanceId = parametersConfig.instanceId().orElse(null);
        multiTenant = parametersConfig.tenant().enabled();
        this.history = new ParametersHistory(instanceId);
        if (parametersConfig.history().enabled()) {
            this.scheduler.newJob("parameters-history").setCron(parametersConfig.history().updateSchedule()).setConcurrentExecution(Scheduled.ConcurrentExecution.SKIP).setTask(this::sendHistory).schedule();
        }
    }

    private void sendHistory(ScheduledExecution scheduledExecution) {
        ParametersHistory tmp = this.history;
        this.history = new ParametersHistory(instanceId);
        tmp.end();
        if (tmp.isEmpty()) {
            return;
        }
        tmp.getTenants().forEach((tenantId, value) -> {
            if (value.isEmpty()) {
                return;
            }
            if (multiTenant) {
                Context ctx = this.resolver.getTenantContext(value.getCtx());
                ApplicationContext.start((Context)ctx);
                try {
                    this.sendMetrics((String)tenantId, this.history, (ParametersHistory.TenantParameters)value);
                }
                finally {
                    ApplicationContext.close();
                }
            } else {
                this.sendMetrics(value.getCtx().getTenantId(), this.history, (ParametersHistory.TenantParameters)value);
            }
        });
    }

    private void sendMetrics(String tenantId, ParametersHistory history, ParametersHistory.TenantParameters parameters) {
        ParametersBucket pb = new ParametersBucket().start(history.getStart()).end(history.getEnd()).instanceId(history.getInstanceId());
        parameters.getParameters().forEach((k, v) -> pb.putParametersItem(k, new ParameterInfo().count(Long.valueOf(v.getCount().get())).currentValue(v.getCurrentValue()).defaultValue(v.getDefaultValue())));
        try (Response response = this.client.bucketRequest(this.config.productName(), this.config.applicationId(), pb);){
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                log.error("Error send metrics to the parameters management. Code: {}", (Object)response.getStatus());
            }
            log.debug("Send metrics. Code: {}", (Object)response.getStatus());
            this.metricsRecorder.history(tenantId, "" + response.getStatus());
        }
        catch (Exception ex) {
            if (ex instanceof WebApplicationException) {
                WebApplicationException w = (WebApplicationException)ex;
                this.metricsRecorder.history(tenantId, "" + w.getResponse().getStatus());
            } else {
                this.metricsRecorder.history(tenantId, "UNDEFINED");
            }
            log.error("Error send metrics to the parameters management. Error: {}", (Object)ex.getMessage());
        }
    }

    @ConsumeEvent(value="ParametersHistoryEvent")
    public void consumeEvent(ParametersHistoryEvent event) {
        this.history.addParameterRequest(event);
    }
}

