/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter.runtime;

import gen.org.tkit.onecx.parameters.v1.api.ParameterV1Api;
import io.quarkus.arc.Arc;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.Scheduler;
import io.vertx.mutiny.core.eventbus.EventBus;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.onecx.quarkus.parameter.TenantException;
import org.tkit.onecx.quarkus.parameter.UpdateException;
import org.tkit.onecx.quarkus.parameter.config.ParametersConfig;
import org.tkit.onecx.quarkus.parameter.history.ParametersHistoryEvent;
import org.tkit.onecx.quarkus.parameter.mapper.ParametersValueMapper;
import org.tkit.onecx.quarkus.parameter.metrics.MetricsRecorder;
import org.tkit.onecx.quarkus.parameter.runtime.TenantParameters;
import org.tkit.onecx.quarkus.parameter.tenant.TenantResolver;
import org.tkit.quarkus.context.ApplicationContext;
import org.tkit.quarkus.context.Context;

@Singleton
public class ParametersDataService {
    private static final Logger log = LoggerFactory.getLogger(ParametersDataService.class);
    static Map<String, TenantParameters> data = new ConcurrentHashMap<String, TenantParameters>();
    static Map<String, Object> localData = new HashMap<String, Object>();
    private static final String DEFAULT_TENANT = "default-tenant";
    static Context ctxDefaultTenant = Context.builder().tenantId("default-tenant").build();
    @Inject
    ParametersValueMapper mapper;
    @Inject
    @RestClient
    ParameterV1Api client;
    @Inject
    ParametersConfig config;
    @Inject
    Scheduler scheduler;
    @Inject
    EventBus bus;
    @Inject
    TenantResolver tenantResolver;
    MetricsRecorder metricsRecorder;
    private static boolean multiTenant;

    public void init(ParametersConfig parametersConfig) {
        multiTenant = parametersConfig.tenant().enabled();
        this.metricsRecorder = (MetricsRecorder)Arc.container().instance(MetricsRecorder.class, new Annotation[0]).get();
        parametersConfig.parameters().forEach((k, v) -> localData.put((String)k, this.mapper.toMap((String)v)));
        if (parametersConfig.cache().enabled()) {
            block6: {
                if (parametersConfig.cache().updateAtStart()) {
                    if (parametersConfig.tenant().enabled()) {
                        log.warn("Update cache at star-up is not supported for multi-tenancy");
                    } else {
                        try {
                            data.put(ctxDefaultTenant.getTenantId(), new TenantParameters(ctxDefaultTenant, this.getParameters(ctxDefaultTenant.getTenantId(), "start-up")));
                        }
                        catch (UpdateException ex) {
                            log.error("Error loading parameters during start of the application. Error: {}", (Object)ex.getMessage(), (Object)ex);
                            if (!parametersConfig.cache().failedAtStart()) break block6;
                            throw ex;
                        }
                    }
                }
            }
            this.scheduler.newJob("parameters-update").setCron(parametersConfig.cache().updateSchedule()).setConcurrentExecution(Scheduled.ConcurrentExecution.SKIP).setTask(this::updateTenants).schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTenants(ScheduledExecution scheduledExecution) {
        HashSet<String> tenants = new HashSet<String>(data.keySet());
        if (tenants.isEmpty()) {
            return;
        }
        for (String tenantId : tenants) {
            if (multiTenant) {
                Context ctx = this.tenantResolver.getTenantContext(data.get(tenantId).getCtx());
                ApplicationContext.start((Context)ctx);
                try {
                    this.updateTenant(tenantId);
                    continue;
                }
                finally {
                    ApplicationContext.close();
                    continue;
                }
            }
            this.updateTenant(tenantId);
        }
    }

    private void updateTenant(String tenantId) {
        try {
            Map<String, Object> params = this.getParameters(tenantId, "scheduler");
            data.get(tenantId).updateParameters(params);
        }
        catch (UpdateException ex) {
            log.warn("Update parameters for tenant: {} failed. Error: {}", (Object)tenantId, (Object)ex.getMessage());
        }
    }

    public <T> T getValue(String name, Class<T> type, T defaultValue) {
        Context ctx = ctxDefaultTenant;
        if (this.config.tenant().enabled() && ((ctx = ApplicationContext.get()) == null || ctx.getTenantId() == null)) {
            throw new TenantException("ApplicationContext with not null tenant-id is required for multi-tenancy");
        }
        T value = defaultValue;
        Object raw = this.getRawValue(ctx, name);
        if (raw != null) {
            value = this.mapper.toType(raw, type);
        }
        this.addHistory(ctx, name, type, value, defaultValue);
        return value;
    }

    private Object getRawValue(Context ctx, String name) {
        Map<Object, Object> params;
        block2: {
            params = new HashMap();
            try {
                params = this.config.cache().enabled() ? data.computeIfAbsent(ctx.getTenantId(), t -> new TenantParameters(ctx, this.getParameters(ctx.getTenantId(), "cache"))).getParameters() : this.getParameters(ctx.getTenantId(), "no-cache");
            }
            catch (UpdateException ex) {
                log.warn("Update parameters during raw value failed. Error: {}", (Object)ex.getMessage());
                if (!this.config.throwUpdateException()) break block2;
                throw ex;
            }
        }
        this.metricsRecorder.increase(name);
        return params.getOrDefault(name, localData.get(name));
    }

    private <T> void addHistory(Context ctx, String name, Class<T> type, T value, T defaultValue) {
        if (!this.config.history().enabled()) {
            return;
        }
        this.bus.send("ParametersHistoryEvent", (Object)ParametersHistoryEvent.of(ctx, name, type, defaultValue, value));
    }

    public Map<String, Object> getParameters(String tenantId, String type) throws UpdateException {
        HashMap hashMap;
        block10: {
            Response response = this.client.getParameters(this.config.productName(), this.config.applicationId());
            try {
                HashMap tmp = (HashMap)response.readEntity((GenericType)new GenericType<HashMap<String, Object>>(){});
                this.metricsRecorder.update(tenantId, type, "" + response.getStatus());
                hashMap = tmp;
                if (response == null) break block10;
            }
            catch (Throwable tmp) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            tmp.addSuppressed(throwable);
                        }
                    }
                    throw tmp;
                }
                catch (Exception ex) {
                    if (ex instanceof WebApplicationException) {
                        WebApplicationException w = (WebApplicationException)ex;
                        this.metricsRecorder.update(tenantId, type, "" + w.getResponse().getStatus());
                    } else {
                        this.metricsRecorder.update(tenantId, type, "UNDEFINED");
                    }
                    throw new UpdateException(ex);
                }
            }
            response.close();
        }
        return hashMap;
    }
}

