/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.DefaultBean;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.tkit.onecx.quarkus.parameter.ConvertValueException;
import org.tkit.onecx.quarkus.parameter.mapper.ParametersValueMapper;

@Singleton
@DefaultBean
public class DefaultParametersValueMapper
implements ParametersValueMapper {
    @Inject
    ObjectMapper mapper;

    @Override
    public <T> T toType(Object value, Class<T> clazz) throws ConvertValueException {
        try {
            return (T)this.mapper.convertValue(value, clazz);
        }
        catch (Exception ex) {
            throw new ConvertValueException("The given value: " + String.valueOf(value) + " cannot be transformed to object: " + String.valueOf(clazz), ex);
        }
    }

    @Override
    public Object toMap(String value) throws ConvertValueException {
        if (value == null) {
            return null;
        }
        try {
            return this.mapper.readValue(value, Object.class);
        }
        catch (Exception ex) {
            throw new ConvertValueException("The given string: " + value + " cannot be transformed to json map", ex);
        }
    }
}

