/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.onecx.quarkus.parameter.config.ParametersConfig;
import org.tkit.onecx.quarkus.parameter.history.ParametersHistoryService;
import org.tkit.onecx.quarkus.parameter.runtime.ParametersDataService;

@Recorder
public class ParametersRecorder {
    private static final Logger log = LoggerFactory.getLogger(ParametersRecorder.class);

    public void configSources(BeanContainer container, ParametersConfig config) {
        if (!config.enabled()) {
            log.debug("No attempt will be made to obtain configuration from Parameters management because the functionality has been disabled via configuration");
            return;
        }
        ParametersDataService service = (ParametersDataService)container.beanInstance(ParametersDataService.class, new Annotation[]{Default.Literal.INSTANCE});
        service.init(config);
        if (config.history().enabled()) {
            ParametersHistoryService metrics = (ParametersHistoryService)container.beanInstance(ParametersHistoryService.class, new Annotation[]{Default.Literal.INSTANCE});
            metrics.init(config);
        }
    }
}

