/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter.history;

import io.quarkus.runtime.annotations.RegisterForReflection;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.tkit.onecx.quarkus.parameter.history.ParametersHistoryEvent;
import org.tkit.quarkus.context.Context;

@RegisterForReflection
public class ParametersHistory {
    private final Map<String, TenantParameters> tenants = new ConcurrentHashMap<String, TenantParameters>();
    private final String instanceId;
    private final OffsetDateTime start;
    private OffsetDateTime end;

    public ParametersHistory(String instanceId) {
        this.instanceId = instanceId;
        this.start = ParametersHistory.now();
    }

    public void end() {
        this.end = ParametersHistory.now();
    }

    public void addParameterRequest(ParametersHistoryEvent event) {
        this.tenants.computeIfAbsent(event.ctx.getTenantId(), t -> new TenantParameters(event.ctx)).addParameter(event.name, event.defaultValue, event.value);
    }

    public Map<String, TenantParameters> getTenants() {
        return this.tenants;
    }

    public OffsetDateTime getEnd() {
        return this.end;
    }

    public OffsetDateTime getStart() {
        return this.start;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean isEmpty() {
        return this.tenants.isEmpty();
    }

    static OffsetDateTime now() {
        return OffsetDateTime.now(ZoneOffset.UTC);
    }

    @RegisterForReflection
    public static class TenantParameters {
        private final Context ctx;
        private final Map<String, ParameterInfoItem> parameters = new ConcurrentHashMap<String, ParameterInfoItem>();

        public TenantParameters(Context ctx) {
            this.ctx = ctx;
        }

        public Context getCtx() {
            return this.ctx;
        }

        public boolean isEmpty() {
            return this.parameters.isEmpty();
        }

        public Map<String, ParameterInfoItem> getParameters() {
            return this.parameters;
        }

        public void addParameter(String name, Object defaultValue, Object currentValue) {
            this.parameters.computeIfAbsent(name, k -> new ParameterInfoItem(defaultValue, currentValue)).getCount().incrementAndGet();
        }
    }

    @RegisterForReflection
    public static class ParameterInfoItem {
        private final AtomicLong count = new AtomicLong(0L);
        private final Object defaultValue;
        private final Object currentValue;

        ParameterInfoItem(Object defaultValue, Object currentValue) {
            this.defaultValue = defaultValue;
            this.currentValue = currentValue;
        }

        public AtomicLong getCount() {
            return this.count;
        }

        public Object getCurrentValue() {
            return this.currentValue;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }
}

