/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter.client;

import gen.org.tkit.onecx.parameters.v1.api.ParameterV1Api;
import gen.org.tkit.onecx.parameters.v1.model.ParameterInfo;
import gen.org.tkit.onecx.parameters.v1.model.ParametersBucket;
import gen.org.tkit.onecx.parameters.v2.api.ParameterV2Api;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.tkit.onecx.quarkus.parameter.config.ParametersConfig;
import org.tkit.onecx.quarkus.parameter.history.ParametersHistory;

@Singleton
public class ClientService {
    @Inject
    @RestClient
    ParameterV1Api clientV1;
    @Inject
    @RestClient
    ParameterV2Api client;
    @Inject
    ParametersConfig config;

    public Response getParameters(String productName, String appId) {
        if (this.config.clientV1()) {
            return this.clientV1.getParameters(productName, appId);
        }
        return this.client.getParameters(productName, appId);
    }

    public Response bucketRequest(String productName, String appId, ParametersHistory history, ParametersHistory.TenantParameters parameters) {
        if (this.config.clientV1()) {
            ParametersBucket pb = new ParametersBucket().start(history.getStart()).end(history.getEnd()).instanceId(history.getInstanceId());
            parameters.getParameters().forEach((k, v) -> pb.putParametersItem(k, new ParameterInfo().count(Long.valueOf(v.getCount().get())).currentValue(v.getCurrentValue()).defaultValue(v.getDefaultValue())));
            return this.clientV1.bucketRequest(productName, appId, pb);
        }
        gen.org.tkit.onecx.parameters.v2.model.ParametersBucket pb = new gen.org.tkit.onecx.parameters.v2.model.ParametersBucket().start(history.getStart()).end(history.getEnd()).instanceId(history.getInstanceId());
        parameters.getParameters().forEach((k, v) -> pb.putParametersItem(k, new gen.org.tkit.onecx.parameters.v2.model.ParameterInfo().count(Long.valueOf(v.getCount().get())).currentValue(v.getCurrentValue()).defaultValue(v.getDefaultValue())));
        return this.client.bucketRequest(productName, appId, pb);
    }
}

