/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.parameter.history;

import io.quarkus.arc.Arc;
import io.quarkus.vertx.ConsumeEvent;
import io.vertx.core.Vertx;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.onecx.quarkus.parameter.client.ClientService;
import org.tkit.onecx.quarkus.parameter.config.ParametersConfig;
import org.tkit.onecx.quarkus.parameter.history.ParametersHistory;
import org.tkit.onecx.quarkus.parameter.history.ParametersHistoryEvent;
import org.tkit.onecx.quarkus.parameter.metrics.MetricsRecorder;
import org.tkit.onecx.quarkus.parameter.tenant.TenantResolver;
import org.tkit.quarkus.context.ApplicationContext;
import org.tkit.quarkus.context.Context;

@Singleton
public class ParametersHistoryService {
    private static final Logger log = LoggerFactory.getLogger(ParametersHistoryService.class);
    @Inject
    ClientService client;
    @Inject
    ParametersConfig config;
    @Inject
    TenantResolver resolver;
    @Inject
    Vertx vertx;
    MetricsRecorder metricsRecorder;
    private ParametersHistory history;
    private static String instanceId;
    private static boolean multiTenant;

    public void init(ParametersConfig parametersConfig) {
        instanceId = parametersConfig.instanceId().orElse(null);
        this.history = new ParametersHistory(instanceId);
        if (!parametersConfig.history().enabled()) {
            return;
        }
        multiTenant = parametersConfig.tenant().enabled();
        this.metricsRecorder = (MetricsRecorder)Arc.container().instance(MetricsRecorder.class, new Annotation[0]).get();
        this.timer();
    }

    private void timer() {
        this.vertx.setTimer(this.config.history().updateSchedule().longValue(), id -> this.vertx.executeBlocking(() -> {
            this.sendHistory();
            this.timer();
            log.info("Update history: {}", id);
            this.vertx.cancelTimer(id.longValue());
            return null;
        }));
    }

    private void sendHistory() {
        ParametersHistory tmp = this.history;
        this.history = new ParametersHistory(instanceId);
        tmp.end();
        if (tmp.isEmpty()) {
            return;
        }
        tmp.getTenants().forEach((tenantId, value) -> {
            if (value.isEmpty()) {
                return;
            }
            if (multiTenant) {
                Context ctx = this.resolver.getTenantContext(value.getCtx());
                ApplicationContext.start((Context)ctx);
                try {
                    this.sendMetrics((String)tenantId, this.history, (ParametersHistory.TenantParameters)value);
                }
                finally {
                    ApplicationContext.close();
                }
            } else {
                this.sendMetrics(value.getCtx().getTenantId(), this.history, (ParametersHistory.TenantParameters)value);
            }
        });
    }

    private void sendMetrics(String tenantId, ParametersHistory history, ParametersHistory.TenantParameters parameters) {
        try (Response response = this.client.bucketRequest(this.config.productName(), this.config.applicationId(), history, parameters);){
            if (response.getStatus() != Response.Status.OK.getStatusCode() && response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                log.error("Error send metrics to the parameters management. Code: {}", (Object)response.getStatus());
            }
            log.debug("Send metrics. Code: {}", (Object)response.getStatus());
            this.metricsRecorder.history(tenantId, "" + response.getStatus());
        }
        catch (Exception ex) {
            if (ex instanceof WebApplicationException) {
                WebApplicationException w = (WebApplicationException)ex;
                this.metricsRecorder.history(tenantId, "" + w.getResponse().getStatus());
            } else {
                this.metricsRecorder.history(tenantId, "UNDEFINED");
            }
            log.error("Error send metrics to the parameters management. Error: {}", (Object)ex.getMessage());
        }
    }

    @ConsumeEvent(value="ParametersHistoryEvent")
    public void consumeEvent(ParametersHistoryEvent event) {
        this.history.addParameterRequest(event);
    }
}

