package gen.org.tkit.onecx.permission.api;

import gen.org.tkit.onecx.permission.model.ApplicationPermissions;
import gen.org.tkit.onecx.permission.model.PermissionRequest;
import gen.org.tkit.onecx.permission.model.ProblemDetailResponse;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import jakarta.enterprise.context.ApplicationScoped;

import io.quarkiverse.openapi.generator.annotations.GeneratedClass;
import io.quarkiverse.openapi.generator.annotations.GeneratedMethod;
import io.quarkiverse.openapi.generator.annotations.GeneratedParam;

/**
  * onecx-permission service
  * <p>No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)</p>
  */
@Path("/v1/permissions/user/{productName}/{appId}")
@RegisterRestClient(baseUri="http://onecx-permission-svc:8080", configKey="onecx_permission")
@GeneratedClass(value="onecx-permission-v1.yaml", tag = "Permission")
@ApplicationScoped
@org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders(org.tkit.onecx.quarkus.permission.client.PermissionDefaultClientHeadersFactoryImpl.class)
public interface PermissionApi {

     /**
     * Get permissions of the product application for the user
     *
     * @param productName Product name
     * @param appId Application ID
     * @param permissionRequest 
     */
    @POST
    @Consumes({"application/json"})
    @Produces({"application/json"})
    @GeneratedMethod ("getApplicationPermissions")
    public io.smallrye.mutiny.Uni<ApplicationPermissions> getApplicationPermissions(
        @GeneratedParam("productName") @PathParam("productName") String productName, 
        @GeneratedParam("appId") @PathParam("appId") String appId, 
        PermissionRequest permissionRequest
    );

}
