/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.permission.client;

import gen.org.tkit.onecx.permission.api.PermissionApi;
import gen.org.tkit.onecx.permission.model.PermissionRequest;
import io.quarkus.arc.Unremovable;
import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheName;
import io.quarkus.cache.CompositeCacheKey;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import java.util.ArrayList;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.onecx.quarkus.permission.client.PermissionResponse;

@Unremovable
@ApplicationScoped
public class PermissionClientService {
    private static final Logger log = LoggerFactory.getLogger(PermissionClientService.class);
    @Inject
    @RestClient
    PermissionApi client;
    @CacheName(value="onecx-permissions")
    Cache cache;

    public Uni<PermissionResponse> getPermissions(String productName, String appName, String token, String keySeparator, boolean cacheEnabled) {
        if (!cacheEnabled) {
            return this.getPermissionsLocal(productName, appName, token, keySeparator);
        }
        CompositeCacheKey key = new CompositeCacheKey(new Object[]{appName, token});
        return this.cache.getAsync((Object)key, compositeCacheKey -> this.getPermissionsLocal(productName, appName, token, keySeparator)).onFailure().recoverWithUni(t -> this.cache.invalidate((Object)key).map(x -> null));
    }

    public Uni<PermissionResponse> getPermissionsLocal(String productName, String appName, String token, String keySeparator) {
        return this.client.getApplicationPermissions(productName, appName, new PermissionRequest().token(token)).map(response -> {
            ArrayList<String> result = new ArrayList<String>();
            if (response.getPermissions() != null) {
                response.getPermissions().forEach((resource, actions) -> {
                    if (actions != null && !actions.isEmpty()) {
                        actions.forEach(action -> result.add(resource + keySeparator + action));
                    }
                });
            }
            return PermissionResponse.create(result);
        }).onFailure().invoke(t -> {
            if (t instanceof WebApplicationException) {
                WebApplicationException e = (WebApplicationException)t;
                e.getResponse().close();
            }
        });
    }
}

