package gen.org.tkit.onecx.permission.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.lang.reflect.Type;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ApplicationPermissions  {

    private String appId;
    private Map<String, Set<String>> permissions;

    /**
    * Get appId
    * @return appId
    **/
    @JsonProperty("appId")
    public String getAppId() {
        return appId;
    }

    /**
     * Set appId
     **/
    public void setAppId(String appId) {
        this.appId = appId;
    }

    public ApplicationPermissions appId(String appId) {
        this.appId = appId;
        return this;
    }

    /**
    * resources
    * @return permissions
    **/
    @JsonProperty("permissions")
    public Map<String, Set<String>> getPermissions() {
        return permissions;
    }

    /**
     * Set permissions
     **/
    public void setPermissions(Map<String, Set<String>> permissions) {
        this.permissions = permissions;
    }

    public ApplicationPermissions permissions(Map<String, Set<String>> permissions) {
        this.permissions = permissions;
        return this;
    }
    public ApplicationPermissions putPermissionsItem(String key, Set<String> permissionsItem) {
        this.permissions.put(key, permissionsItem);
        return this;
    }

    /**
     * Create a string representation of this pojo.
     **/
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationPermissions {\n");

        sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
        sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
        
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class ApplicationPermissionsQueryParam  {

        @jakarta.ws.rs.QueryParam("appId")
        private String appId;
        @jakarta.ws.rs.QueryParam("permissions")
        private Map<String, Set<String>> permissions = null;

        /**
        * Get appId
        * @return appId
        **/
        @JsonProperty("appId")
        public String getAppId() {
            return appId;
        }

        /**
         * Set appId
         **/
        public void setAppId(String appId) {
            this.appId = appId;
        }

        public ApplicationPermissionsQueryParam appId(String appId) {
            this.appId = appId;
            return this;
        }

        /**
        * resources
        * @return permissions
        **/
        @JsonProperty("permissions")
        public Map<String, Set<String>> getPermissions() {
            return permissions;
        }

        /**
         * Set permissions
         **/
        public void setPermissions(Map<String, Set<String>> permissions) {
            this.permissions = permissions;
        }

        public ApplicationPermissionsQueryParam permissions(Map<String, Set<String>> permissions) {
            this.permissions = permissions;
            return this;
        }
        public ApplicationPermissionsQueryParam putPermissionsItem(String key, Set<String> permissionsItem) {
            this.permissions.put(key, permissionsItem);
            return this;
        }

        /**
         * Create a string representation of this pojo.
         **/
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class ApplicationPermissionsQueryParam {\n");

            sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
            sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
            sb.append("}");
            return sb.toString();
        }

        /**
         * Convert the given object to string with each line indented by 4 spaces
         * (except the first line).
         */
        private static String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }
}