package gen.org.tkit.onecx.permission.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import gen.org.tkit.onecx.permission.model.ApplicationPermissions;
import gen.org.tkit.onecx.permission.model.WorkspacePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.lang.reflect.Type;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class WorkspacePermissionApplications  {

    private WorkspacePermissions workspace;
    private List<ApplicationPermissions> applications;

    /**
    * Get workspace
    * @return workspace
    **/
    @JsonProperty("workspace")
    public WorkspacePermissions getWorkspace() {
        return workspace;
    }

    /**
     * Set workspace
     **/
    public void setWorkspace(WorkspacePermissions workspace) {
        this.workspace = workspace;
    }

    public WorkspacePermissionApplications workspace(WorkspacePermissions workspace) {
        this.workspace = workspace;
        return this;
    }

    /**
    * Get applications
    * @return applications
    **/
    @JsonProperty("applications")
    public List<ApplicationPermissions> getApplications() {
        return applications;
    }

    /**
     * Set applications
     **/
    public void setApplications(List<ApplicationPermissions> applications) {
        this.applications = applications;
    }

    public WorkspacePermissionApplications applications(List<ApplicationPermissions> applications) {
        this.applications = applications;
        return this;
    }
    public WorkspacePermissionApplications addApplicationsItem(ApplicationPermissions applicationsItem) {
        this.applications.add(applicationsItem);
        return this;
    }

    /**
     * Create a string representation of this pojo.
     **/
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkspacePermissionApplications {\n");

        sb.append("    workspace: ").append(toIndentedString(workspace)).append("\n");
        sb.append("    applications: ").append(toIndentedString(applications)).append("\n");
        
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class WorkspacePermissionApplicationsQueryParam  {

        @jakarta.ws.rs.QueryParam("workspace")
        private WorkspacePermissions workspace;
        @jakarta.ws.rs.QueryParam("applications")
        private List<ApplicationPermissions> applications = null;

        /**
        * Get workspace
        * @return workspace
        **/
        @JsonProperty("workspace")
        public WorkspacePermissions getWorkspace() {
            return workspace;
        }

        /**
         * Set workspace
         **/
        public void setWorkspace(WorkspacePermissions workspace) {
            this.workspace = workspace;
        }

        public WorkspacePermissionApplicationsQueryParam workspace(WorkspacePermissions workspace) {
            this.workspace = workspace;
            return this;
        }

        /**
        * Get applications
        * @return applications
        **/
        @JsonProperty("applications")
        public List<ApplicationPermissions> getApplications() {
            return applications;
        }

        /**
         * Set applications
         **/
        public void setApplications(List<ApplicationPermissions> applications) {
            this.applications = applications;
        }

        public WorkspacePermissionApplicationsQueryParam applications(List<ApplicationPermissions> applications) {
            this.applications = applications;
            return this;
        }
        public WorkspacePermissionApplicationsQueryParam addApplicationsItem(ApplicationPermissions applicationsItem) {
            this.applications.add(applicationsItem);
            return this;
        }

        /**
         * Create a string representation of this pojo.
         **/
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class WorkspacePermissionApplicationsQueryParam {\n");

            sb.append("    workspace: ").append(toIndentedString(workspace)).append("\n");
            sb.append("    applications: ").append(toIndentedString(applications)).append("\n");
            sb.append("}");
            return sb.toString();
        }

        /**
         * Convert the given object to string with each line indented by 4 spaces
         * (except the first line).
         */
        private static String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }
}