package gen.org.tkit.onecx.permission.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.lang.reflect.Type;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class WorkspacePermissions  {

    private String workspaceId;
    private Map<String, Set<String>> permissions;

    /**
    * Get workspaceId
    * @return workspaceId
    **/
    @JsonProperty("workspaceId")
    public String getWorkspaceId() {
        return workspaceId;
    }

    /**
     * Set workspaceId
     **/
    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public WorkspacePermissions workspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    /**
    * resources
    * @return permissions
    **/
    @JsonProperty("permissions")
    public Map<String, Set<String>> getPermissions() {
        return permissions;
    }

    /**
     * Set permissions
     **/
    public void setPermissions(Map<String, Set<String>> permissions) {
        this.permissions = permissions;
    }

    public WorkspacePermissions permissions(Map<String, Set<String>> permissions) {
        this.permissions = permissions;
        return this;
    }
    public WorkspacePermissions putPermissionsItem(String key, Set<String> permissionsItem) {
        this.permissions.put(key, permissionsItem);
        return this;
    }

    /**
     * Create a string representation of this pojo.
     **/
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkspacePermissions {\n");

        sb.append("    workspaceId: ").append(toIndentedString(workspaceId)).append("\n");
        sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
        
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class WorkspacePermissionsQueryParam  {

        @jakarta.ws.rs.QueryParam("workspaceId")
        private String workspaceId;
        @jakarta.ws.rs.QueryParam("permissions")
        private Map<String, Set<String>> permissions = null;

        /**
        * Get workspaceId
        * @return workspaceId
        **/
        @JsonProperty("workspaceId")
        public String getWorkspaceId() {
            return workspaceId;
        }

        /**
         * Set workspaceId
         **/
        public void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public WorkspacePermissionsQueryParam workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        /**
        * resources
        * @return permissions
        **/
        @JsonProperty("permissions")
        public Map<String, Set<String>> getPermissions() {
            return permissions;
        }

        /**
         * Set permissions
         **/
        public void setPermissions(Map<String, Set<String>> permissions) {
            this.permissions = permissions;
        }

        public WorkspacePermissionsQueryParam permissions(Map<String, Set<String>> permissions) {
            this.permissions = permissions;
            return this;
        }
        public WorkspacePermissionsQueryParam putPermissionsItem(String key, Set<String> permissionsItem) {
            this.permissions.put(key, permissionsItem);
            return this;
        }

        /**
         * Create a string representation of this pojo.
         **/
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class WorkspacePermissionsQueryParam {\n");

            sb.append("    workspaceId: ").append(toIndentedString(workspaceId)).append("\n");
            sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
            sb.append("}");
            return sb.toString();
        }

        /**
         * Convert the given object to string with each line indented by 4 spaces
         * (except the first line).
         */
        private static String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }
}