/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.permission;

import io.quarkus.security.StringPermission;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tkit.onecx.quarkus.permission.PermissionRuntimeConfig;

@ApplicationScoped
public class MockPermissionService {
    @Inject
    PermissionRuntimeConfig config;

    public Uni<SecurityIdentity> getMockData(SecurityIdentity identity) {
        if (identity.getPrincipal() == null) {
            return Uni.createFrom().item((Object)identity);
        }
        Set roles = identity.getRoles();
        if (roles == null || roles.isEmpty()) {
            return Uni.createFrom().item((Object)identity);
        }
        ArrayList mockData = new ArrayList();
        roles.forEach(role -> {
            Map<String, List<String>> data = this.config.mock().roles().get(role);
            if (data != null) {
                data.forEach((resource, actions) -> mockData.addAll(actions.stream().map(action -> resource + this.config.keySeparator() + action).toList()));
            }
        });
        StringPermission mockPermissions = new StringPermission(this.config.name(), mockData.toArray(new String[0]));
        return Uni.createFrom().item((Object)QuarkusSecurityIdentity.builder((SecurityIdentity)identity).addPermissionChecker(requiredPermission -> {
            boolean accessGranted = mockPermissions.implies(requiredPermission);
            return Uni.createFrom().item((Object)accessGranted);
        }).build());
    }
}

