/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.permission.service;

import gen.org.tkit.onecx.permission.api.PermissionApi;
import gen.org.tkit.onecx.permission.model.PermissionRequest;
import io.quarkus.arc.Unremovable;
import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheName;
import io.quarkus.cache.CompositeCacheKey;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.control.ActivateRequestContext;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import java.util.ArrayList;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.tkit.onecx.quarkus.permission.PermissionRuntimeConfig;
import org.tkit.onecx.quarkus.permission.client.RequestHeaderContainer;
import org.tkit.onecx.quarkus.permission.service.PermissionResponse;

@Unremovable
@ApplicationScoped
public class PermissionClientService {
    @Inject
    @RestClient
    PermissionApi client;
    @CacheName(value="onecx-permissions")
    Cache cache;

    public Uni<PermissionResponse> getPermissions(HttpServerRequest request, PermissionRuntimeConfig config) {
        String token = request.getHeader(config.requestTokenHeaderParam());
        if (!config.cacheEnabled()) {
            return this.getPermissionsLocal(request, config, token);
        }
        CompositeCacheKey key = new CompositeCacheKey(new Object[]{config.productName(), config.applicationId(), token});
        return this.cache.getAsync((Object)key, compositeCacheKey -> this.getPermissionsLocal(request, config, token)).onFailure().recoverWithUni(t -> this.cache.invalidate((Object)key).map(x -> null));
    }

    @ActivateRequestContext
    public Uni<PermissionResponse> getPermissionsLocal(HttpServerRequest request, PermissionRuntimeConfig config, String token) {
        RequestHeaderContainer headerContainer = new RequestHeaderContainer();
        headerContainer.setContainerRequestContext(request.headers(), config.principalTokenHeaderParam());
        Context ctx = Vertx.currentContext();
        ctx.putLocal((Object)RequestHeaderContainer.class.getName(), (Object)headerContainer);
        return this.client.getApplicationPermissions(config.productName(), config.applicationId(), new PermissionRequest().token(token)).map(response -> {
            ctx.removeLocal((Object)RequestHeaderContainer.class.getName());
            ArrayList<String> result = new ArrayList<String>();
            if (response.getPermissions() != null) {
                response.getPermissions().forEach((resource, actions) -> {
                    if (actions != null && !actions.isEmpty()) {
                        actions.forEach(action -> result.add(resource + config.keySeparator() + action));
                    }
                });
            }
            return PermissionResponse.create(result);
        }).onFailure().invoke(t -> {
            ctx.removeLocal((Object)RequestHeaderContainer.class.getName());
            if (t instanceof WebApplicationException) {
                WebApplicationException e = (WebApplicationException)t;
                e.getResponse().close();
            }
        });
    }
}

