/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.permission;

import io.quarkus.arc.Unremovable;
import io.quarkus.security.StringPermission;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import org.tkit.onecx.quarkus.permission.MockPermissionService;
import org.tkit.onecx.quarkus.permission.PermissionRuntimeConfig;
import org.tkit.onecx.quarkus.permission.service.PermissionClientService;

@Unremovable
@ApplicationScoped
public class OnecxSecurityIdentityAugmentor
implements SecurityIdentityAugmentor {
    @Inject
    PermissionRuntimeConfig config;
    @Inject
    PermissionClientService service;
    @Inject
    MockPermissionService mockPermissionService;

    public Uni<SecurityIdentity> augment(SecurityIdentity identity, AuthenticationRequestContext context) {
        return Uni.createFrom().item((Object)identity);
    }

    public Uni<SecurityIdentity> augment(SecurityIdentity identity, AuthenticationRequestContext context, Map<String, Object> attributes) {
        if (identity.isAnonymous()) {
            return Uni.createFrom().item((Object)identity);
        }
        if (!this.config.enabled()) {
            if (this.config.allowAll()) {
                return Uni.createFrom().item((Object)QuarkusSecurityIdentity.builder((SecurityIdentity)identity).addPermissionChecker(permission -> Uni.createFrom().item((Object)true)).build());
            }
            return Uni.createFrom().item((Object)identity);
        }
        if (this.config.mock().enabled()) {
            return this.mockPermissionService.getMockData(identity);
        }
        RoutingContext routingContext = HttpSecurityUtils.getRoutingContextAttribute(attributes);
        if (routingContext == null) {
            return Uni.createFrom().item((Object)identity);
        }
        return this.service.getPermissions(routingContext.request(), this.config).onItem().transformToUni(response -> {
            if (response == null) {
                return Uni.createFrom().item((Object)identity);
            }
            List<String> actions = response.getActions();
            if (actions == null) {
                return Uni.createFrom().item((Object)identity);
            }
            StringPermission possessedPermission = new StringPermission(this.config.name(), actions.toArray(new String[0]));
            return Uni.createFrom().item((Object)QuarkusSecurityIdentity.builder((SecurityIdentity)identity).addPermissionChecker(requiredPermission -> {
                boolean accessGranted = possessedPermission.implies(requiredPermission);
                return Uni.createFrom().item((Object)accessGranted);
            }).build());
        }).onFailure().recoverWithItem((Object)identity);
    }
}

