/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.it.parameter;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.tkit.onecx.quarkus.it.parameter.TestParam;
import org.tkit.onecx.quarkus.parameter.ParametersService;

@Path(value="parameters")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TestRestController {
    @Inject
    ParametersService parametersService;

    @GET
    @Path(value="{name}/{type}")
    public Response parameters(@PathParam(value="name") String name, @PathParam(value="type") String type) {
        String value = switch (type) {
            case "String" -> (String)this.parametersService.getValue(name, String.class, (Object)"NO_STRING_VALUE");
            case "Integer" -> (Integer)this.parametersService.getValue(name, Integer.class, (Object)Integer.MIN_VALUE);
            case "Boolean" -> (Boolean)this.parametersService.getValue(name, Boolean.class, (Object)Boolean.FALSE);
            default -> "NO_VALUE";
        };
        return Response.ok((Object)value).build();
    }

    @GET
    @Path(value="testParam")
    public Response testParam() {
        this.parametersService.getValue("DOES_NOT_EXISTS_1", String.class, (Object)"{\"x\": true, \"data\": {\"a\": 100 }}");
        this.parametersService.getValue("DOES_NOT_EXISTS_2", Boolean.TYPE, (Object)true);
        return Response.ok((Object)this.parametersService.getValue("C_PARAM_TEXT_4", TestParam.class)).build();
    }
}

