/*
 * Decompiled with CFR 0.152.
 */
package gen.org.tkit.onecx.quarkus.permission.example;

import gen.org.tkit.onecx.quarkus.permission.example.model.CreateRoleRequestDTO;
import gen.org.tkit.onecx.quarkus.permission.example.model.ProblemDetailResponseDTO;
import gen.org.tkit.onecx.quarkus.permission.example.model.RoleDTO;
import gen.org.tkit.onecx.quarkus.permission.example.model.RolePageResultDTO;
import gen.org.tkit.onecx.quarkus.permission.example.model.RoleSearchCriteriaDTO;
import gen.org.tkit.onecx.quarkus.permission.example.model.UpdateRoleRequestDTO;
import io.quarkus.security.PermissionsAllowed;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.OpenAPIDefinition;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.headers.Header;
import org.eclipse.microprofile.openapi.annotations.info.Info;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;

@OpenAPIDefinition(info=@Info(title="roleInternal", version="1.0.0", description=""), tags={@Tag(name="roleInternal", description="")})
@Path(value="/internal/roles")
public interface RoleInternalApi {
    @PermissionsAllowed(value={"onecx:resource1#read", "onecx:resource1#write", "onecx:resource1#all"})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(operationId="createRole", summary="", description="Create new role")
    @Tag(name="roleInternal")
    @APIResponses(value={@APIResponse(responseCode="201", description="New role created", headers={@Header(name="Location", schema=@Schema(type=SchemaType.STRING), description="")}, content={@Content(mediaType="application/json", schema=@Schema(implementation=RoleDTO.class))}), @APIResponse(responseCode="400", description="Bad request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProblemDetailResponseDTO.class))})})
    public Response createRole(@Valid @NotNull CreateRoleRequestDTO var1);

    @PermissionsAllowed(value={"onecx:resource1#delete", "onecx:resource1#all"})
    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteRole", summary="", description="Delete role by ID")
    @Tag(name="roleInternal")
    @APIResponses(value={@APIResponse(responseCode="204", description="Role deleted", content={})})
    public Response deleteRole(@PathParam(value="id") String var1);

    @PermissionsAllowed(value={"onecx:resource1#read"})
    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Operation(operationId="getRoleById", summary="", description="Return role by ID")
    @Tag(name="roleInternal")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoleDTO.class))}), @APIResponse(responseCode="404", description="Role not found", content={@Content(mediaType="application/json")})})
    public Response getRoleById(@PathParam(value="id") String var1);

    @POST
    @Path(value="/search")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(operationId="searchRoles", summary="", description="Search for roles")
    @Tag(name="roleInternal")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=RolePageResultDTO.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="400", description="Bad request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProblemDetailResponseDTO.class))})})
    public Response searchRoles(@Valid @NotNull RoleSearchCriteriaDTO var1);

    @PermissionsAllowed(value={"onecx:resource1#write"})
    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(operationId="updateRole", summary="", description="Update role by ID")
    @Tag(name="roleInternal")
    @APIResponses(value={@APIResponse(responseCode="204", description="Theme updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoleDTO.class))}), @APIResponse(responseCode="400", description="Bad request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProblemDetailResponseDTO.class))}), @APIResponse(responseCode="404", description="Role not found", content={@Content(mediaType="application/json")})})
    public Response updateRole(@PathParam(value="id") String var1, @Valid @NotNull UpdateRoleRequestDTO var2);
}

