/*
 * Decompiled with CFR 0.152.
 */
package gen.org.tkit.onecx.quarkus.security.example;

import gen.org.tkit.onecx.quarkus.security.example.model.CreateRoleRequestDTO;
import gen.org.tkit.onecx.quarkus.security.example.model.ProblemDetailResponseDTO;
import gen.org.tkit.onecx.quarkus.security.example.model.RoleDTO;
import gen.org.tkit.onecx.quarkus.security.example.model.UpdateRoleRequestDTO;
import io.quarkus.security.PermissionsAllowed;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.OpenAPIDefinition;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.enums.SecuritySchemeType;
import org.eclipse.microprofile.openapi.annotations.headers.Header;
import org.eclipse.microprofile.openapi.annotations.info.Info;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.security.OAuthFlow;
import org.eclipse.microprofile.openapi.annotations.security.OAuthFlows;
import org.eclipse.microprofile.openapi.annotations.security.OAuthScope;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirements;
import org.eclipse.microprofile.openapi.annotations.security.SecurityScheme;
import org.eclipse.microprofile.openapi.annotations.security.SecuritySchemes;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;

@OpenAPIDefinition(info=@Info(title="roleInternal", version="1.0.0", description=""), tags={@Tag(name="roleInternal", description="")})
@Tag(name="roleInternal", description="")
@SecuritySchemes(value={@SecurityScheme(securitySchemeName="oauth2", type=SecuritySchemeType.OAUTH2, description="", flows=@OAuthFlows(clientCredentials=@OAuthFlow(authorizationUrl="", tokenUrl="https://oauth.simple.api/token", refreshUrl="", scopes={@OAuthScope(name="microprofile-jwt", description="test scope"), @OAuthScope(name="read", description="Grants read access"), @OAuthScope(name="write", description="Grants write access"), @OAuthScope(name="admin", description="Grants access to admin operations")})))})
@Path(value="/internal/roles")
public interface RoleInternalApi {
    @PermissionsAllowed(value={"read"})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SecurityRequirements(value={@SecurityRequirement(name="oauth2", scopes={"read"})})
    @Operation(operationId="createRole", summary="", description="Create new role")
    @Tag(name="roleInternal")
    @APIResponses(value={@APIResponse(responseCode="201", description="New role created", headers={@Header(name="Location", schema=@Schema(type=SchemaType.STRING), description="")}, content={@Content(mediaType="application/json", schema=@Schema(implementation=RoleDTO.class))}), @APIResponse(responseCode="400", description="Bad request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProblemDetailResponseDTO.class))})})
    public Response createRole(@Valid @NotNull CreateRoleRequestDTO var1);

    @PermissionsAllowed(value={"write"})
    @DELETE
    @Path(value="/{id}")
    @SecurityRequirements(value={@SecurityRequirement(name="oauth2", scopes={"write"})})
    @Operation(operationId="deleteRole", summary="", description="Delete role by ID")
    @Tag(name="roleInternal")
    @APIResponses(value={@APIResponse(responseCode="204", description="Role deleted", content={})})
    public Response deleteRole(@PathParam(value="id") String var1);

    @PermissionsAllowed(value={"read", "microprofile-jwt"})
    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @SecurityRequirements(value={@SecurityRequirement(name="oauth2", scopes={"read", "microprofile-jwt"})})
    @Operation(operationId="getRoleById", summary="", description="Return role by ID")
    @Tag(name="roleInternal")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoleDTO.class))}), @APIResponse(responseCode="404", description="Role not found", content={@Content(mediaType="application/json")})})
    public Response getRoleById(@PathParam(value="id") String var1);

    @PermissionsAllowed(value={"write"})
    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SecurityRequirements(value={@SecurityRequirement(name="oauth2", scopes={"write"})})
    @Operation(operationId="updateRole", summary="", description="Update role by ID")
    @Tag(name="roleInternal")
    @APIResponses(value={@APIResponse(responseCode="204", description="Theme updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoleDTO.class))}), @APIResponse(responseCode="400", description="Bad request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProblemDetailResponseDTO.class))}), @APIResponse(responseCode="404", description="Role not found", content={@Content(mediaType="application/json")})})
    public Response updateRole(@PathParam(value="id") String var1, @Valid @NotNull UpdateRoleRequestDTO var2);
}

