package gen.org.tkit.onecx.quarkus.security.example;

import gen.org.tkit.onecx.quarkus.security.example.model.CreateRoleRequestDTO;
import gen.org.tkit.onecx.quarkus.security.example.model.ProblemDetailResponseDTO;
import gen.org.tkit.onecx.quarkus.security.example.model.RoleDTO;
import gen.org.tkit.onecx.quarkus.security.example.model.UpdateRoleRequestDTO;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.Response;




import java.io.InputStream;
import java.util.Map;
import java.util.List;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

@org.eclipse.microprofile.openapi.annotations.OpenAPIDefinition(
   info = @org.eclipse.microprofile.openapi.annotations.info.Info(
        title = "roleInternal", version="1.0.0", description=""
   ),
   tags = @org.eclipse.microprofile.openapi.annotations.tags.Tag(name="roleInternal", description="")
)
@org.eclipse.microprofile.openapi.annotations.tags.Tag(name="roleInternal", description="")
@org.eclipse.microprofile.openapi.annotations.security.SecuritySchemes(value = {
    @org.eclipse.microprofile.openapi.annotations.security.SecurityScheme(
         securitySchemeName = "oauth2",
         type = org.eclipse.microprofile.openapi.annotations.enums.SecuritySchemeType.OAUTH2,
         description = "",
         flows = @org.eclipse.microprofile.openapi.annotations.security.OAuthFlows(
            clientCredentials = @org.eclipse.microprofile.openapi.annotations.security.OAuthFlow(authorizationUrl = "",
            tokenUrl = "https://oauth.simple.api/token",
            refreshUrl = "",
            scopes = {
                @org.eclipse.microprofile.openapi.annotations.security.OAuthScope(name = "microprofile-jwt", description = "test scope"),
                @org.eclipse.microprofile.openapi.annotations.security.OAuthScope(name = "read", description = "Grants read access"),
                @org.eclipse.microprofile.openapi.annotations.security.OAuthScope(name = "write", description = "Grants write access"),
                @org.eclipse.microprofile.openapi.annotations.security.OAuthScope(name = "admin", description = "Grants access to admin operations")
                 }))
    )
})
@Path("/internal/roles")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2025-05-16T14:03:12.038299657Z[Etc/UTC]", comments = "Generator version: 7.13.0")
public interface RoleInternalApi {


    
    
    @io.quarkus.security.PermissionsAllowed({ "read" })

@POST
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @org.eclipse.microprofile.openapi.annotations.security.SecurityRequirements(value = {
    @org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement(
    name = "oauth2",
    scopes = {  "read"  })
     })
    @org.eclipse.microprofile.openapi.annotations.Operation(operationId = "createRole", summary = "", description = "Create new role")
    @org.eclipse.microprofile.openapi.annotations.tags.Tag(name="roleInternal")
        @org.eclipse.microprofile.openapi.annotations.responses.APIResponses(value = { 
            @org.eclipse.microprofile.openapi.annotations.responses.APIResponse(responseCode = "201", description = "New role created", headers = { 
                @org.eclipse.microprofile.openapi.annotations.headers.Header(name = "Location", schema = @org.eclipse.microprofile.openapi.annotations.media.Schema(type = org.eclipse.microprofile.openapi.annotations.enums.SchemaType.STRING), description = "")
            }, content = { 
                @org.eclipse.microprofile.openapi.annotations.media.Content(mediaType = "application/json", schema = @org.eclipse.microprofile.openapi.annotations.media.Schema(implementation = RoleDTO.class))
            }),
            @org.eclipse.microprofile.openapi.annotations.responses.APIResponse(responseCode = "400", description = "Bad request",  content = { 
                @org.eclipse.microprofile.openapi.annotations.media.Content(mediaType = "application/json", schema = @org.eclipse.microprofile.openapi.annotations.media.Schema(implementation = ProblemDetailResponseDTO.class))
            })
        })
Response createRole(@Valid @NotNull CreateRoleRequestDTO createRoleRequestDTO);


    
    
    @io.quarkus.security.PermissionsAllowed({ "write" })

@DELETE
    @Path("/{id}")
    @org.eclipse.microprofile.openapi.annotations.security.SecurityRequirements(value = {
    @org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement(
    name = "oauth2",
    scopes = {  "write"  })
     })
    @org.eclipse.microprofile.openapi.annotations.Operation(operationId = "deleteRole", summary = "", description = "Delete role by ID")
    @org.eclipse.microprofile.openapi.annotations.tags.Tag(name="roleInternal")
        @org.eclipse.microprofile.openapi.annotations.responses.APIResponses(value = { 
            @org.eclipse.microprofile.openapi.annotations.responses.APIResponse(responseCode = "204", description = "Role deleted",  content = {
            
            })
        })
Response deleteRole(@PathParam("id")

 String id);


    
    
    @io.quarkus.security.PermissionsAllowed({ "read","microprofile-jwt" })

@GET
    @Path("/{id}")
    @Produces({ "application/json" })
    @org.eclipse.microprofile.openapi.annotations.security.SecurityRequirements(value = {
    @org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement(
    name = "oauth2",
    scopes = {  "read",  "microprofile-jwt"  })
     })
    @org.eclipse.microprofile.openapi.annotations.Operation(operationId = "getRoleById", summary = "", description = "Return role by ID")
    @org.eclipse.microprofile.openapi.annotations.tags.Tag(name="roleInternal")
        @org.eclipse.microprofile.openapi.annotations.responses.APIResponses(value = { 
            @org.eclipse.microprofile.openapi.annotations.responses.APIResponse(responseCode = "200", description = "OK",  content = { 
                @org.eclipse.microprofile.openapi.annotations.media.Content(mediaType = "application/json", schema = @org.eclipse.microprofile.openapi.annotations.media.Schema(implementation = RoleDTO.class))
            }),
            @org.eclipse.microprofile.openapi.annotations.responses.APIResponse(responseCode = "404", description = "Role not found",  content = { 
                @org.eclipse.microprofile.openapi.annotations.media.Content(mediaType = "application/json")
            })
        })
Response getRoleById(@PathParam("id")

 String id);


    
    
    @io.quarkus.security.PermissionsAllowed({ "write" })

@PUT
    @Path("/{id}")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @org.eclipse.microprofile.openapi.annotations.security.SecurityRequirements(value = {
    @org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement(
    name = "oauth2",
    scopes = {  "write"  })
     })
    @org.eclipse.microprofile.openapi.annotations.Operation(operationId = "updateRole", summary = "", description = "Update role by ID")
    @org.eclipse.microprofile.openapi.annotations.tags.Tag(name="roleInternal")
        @org.eclipse.microprofile.openapi.annotations.responses.APIResponses(value = { 
            @org.eclipse.microprofile.openapi.annotations.responses.APIResponse(responseCode = "204", description = "Theme updated",  content = { 
                @org.eclipse.microprofile.openapi.annotations.media.Content(mediaType = "application/json", schema = @org.eclipse.microprofile.openapi.annotations.media.Schema(implementation = RoleDTO.class))
            }),
            @org.eclipse.microprofile.openapi.annotations.responses.APIResponse(responseCode = "400", description = "Bad request",  content = { 
                @org.eclipse.microprofile.openapi.annotations.media.Content(mediaType = "application/json", schema = @org.eclipse.microprofile.openapi.annotations.media.Schema(implementation = ProblemDetailResponseDTO.class))
            }),
            @org.eclipse.microprofile.openapi.annotations.responses.APIResponse(responseCode = "404", description = "Role not found",  content = { 
                @org.eclipse.microprofile.openapi.annotations.media.Content(mediaType = "application/json")
            })
        })
Response updateRole(@PathParam("id")

 String id,@Valid @NotNull UpdateRoleRequestDTO updateRoleRequestDTO);
}
