/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.security;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.security.deployment.AdditionalSecurityCheckBuildItem;
import io.quarkus.security.deployment.DotNames;
import io.quarkus.security.runtime.SecurityCheckRecorder;
import io.quarkus.security.spi.runtime.SecurityCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.tkit.onecx.quarkus.security.CopyPermissionSecurityChecks;
import org.tkit.onecx.quarkus.security.SecurityBuildTimeConfig;

public class SecurityProcessor {
    static final String FEATURE_NAME = "onecx-security";

    @BuildStep
    void build(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(FEATURE_NAME));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildImplPermissions(SecurityBuildTimeConfig config, BeanArchiveIndexBuildItem ci, SecurityCheckRecorder recorder, BuildProducer<AdditionalSecurityCheckBuildItem> additionalSecurityChecks) {
        HashMap<ClassInfo, AnnotationInstance> classAnnotations;
        HashMap<MethodInfo, AnnotationInstance> methodToInstanceCollector;
        Map<MethodInfo, SecurityCheck> securityChecks;
        if (!config.mapping.enabled) {
            return;
        }
        IndexView index = ci.getIndex();
        ArrayList<AnnotationInstance> permissionInstances = new ArrayList<AnnotationInstance>(index.getAnnotationsWithRepeatable(DotNames.PERMISSIONS_ALLOWED, index));
        if (!permissionInstances.isEmpty() && !(securityChecks = new CopyPermissionSecurityChecks.PermissionSecurityChecksBuilder(recorder).gatherPermissionsAllowedAnnotations(permissionInstances, methodToInstanceCollector = new HashMap<MethodInfo, AnnotationInstance>(), classAnnotations = new HashMap<ClassInfo, AnnotationInstance>()).validatePermissionClasses(index).createPermissionPredicates().build().get()).isEmpty()) {
            for (Map.Entry<MethodInfo, SecurityCheck> e : securityChecks.entrySet()) {
                MethodInfo methodInfo = e.getKey();
                ClassInfo tmp = methodInfo.declaringClass();
                if (SecurityProcessor.isNotPackage(config, tmp.name()) || !tmp.isInterface()) continue;
                Collection classes = index.getKnownDirectImplementors(tmp.name());
                for (ClassInfo clas : classes) {
                    MethodInfo method;
                    if (SecurityProcessor.isNotPackage(config, clas.name()) || (method = clas.method(methodInfo.name(), methodInfo.parameterTypes().toArray(new Type[0]))) == null || method.hasAnnotation(DotNames.PERMISSIONS_ALLOWED)) continue;
                    additionalSecurityChecks.produce((BuildItem)new AdditionalSecurityCheckBuildItem(method, e.getValue()));
                }
            }
        }
    }

    @BuildStep
    AnnotationsTransformerBuildItem transform(final SecurityBuildTimeConfig config, CombinedIndexBuildItem ci) {
        if (!config.mapping.enabled) {
            return new AnnotationsTransformerBuildItem(transformationContext -> {});
        }
        final IndexView index = ci.getIndex();
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.METHOD;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                MethodInfo method = context.getTarget().asMethod();
                ClassInfo classInfo = method.declaringClass();
                if (method.hasAnnotation(DotNames.PERMISSIONS_ALLOWED)) {
                    return;
                }
                if (classInfo.isInterface()) {
                    return;
                }
                if (SecurityProcessor.isNotPackage(config, classInfo.name())) {
                    return;
                }
                AnnotationInstance ai = null;
                List interfaces = classInfo.interfaceNames();
                for (DotName item : interfaces) {
                    ClassInfo ite = index.getClassByName(item);
                    if (ite == null) continue;
                    if (SecurityProcessor.isNotPackage(config, ite.name())) {
                        return;
                    }
                    MethodInfo m = ite.method(method.name(), method.parameterTypes().toArray(new Type[0]));
                    if (m == null || (ai = m.annotation(DotNames.PERMISSIONS_ALLOWED)) == null) continue;
                    break;
                }
                if (ai == null) {
                    return;
                }
                List<AnnotationValue> values = ai.value().asArrayList().stream().map(x -> AnnotationValue.createStringValue((String)x.name(), (String)x.asString())).toList();
                context.transform().add(DotNames.PERMISSIONS_ALLOWED, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", values)}).done();
            }
        });
    }

    private static boolean isNotPackage(SecurityBuildTimeConfig config, DotName name) {
        String n = name.toString();
        Optional<String> add = config.mapping.packages.stream().filter(n::startsWith).findFirst();
        return add.isEmpty();
    }
}

