/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.security;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.security.deployment.AdditionalSecurityCheckBuildItem;
import io.quarkus.security.deployment.DotNames;
import io.quarkus.security.runtime.SecurityCheckRecorder;
import io.quarkus.security.spi.runtime.SecurityCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.onecx.quarkus.security.CopyPermissionSecurityChecks;
import org.tkit.onecx.quarkus.security.SecurityBuildTimeConfig;

public class SecurityProcessor {
    static final String FEATURE_NAME = "onecx-security";
    private static final Logger log = LoggerFactory.getLogger(SecurityProcessor.class);

    @BuildStep
    void build(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(FEATURE_NAME));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildImplPermissions(SecurityBuildTimeConfig config, BeanArchiveIndexBuildItem ci, SecurityCheckRecorder recorder, BuildProducer<AdditionalSecurityCheckBuildItem> additionalSecurityChecks) {
        if (!config.mapping().enabled()) {
            log.info("Permissions annotation build check is disabled");
            return;
        }
        IndexView index = ci.getIndex();
        ArrayList<AnnotationInstance> permissionInstances = new ArrayList<AnnotationInstance>(index.getAnnotationsWithRepeatable(DotNames.PERMISSIONS_ALLOWED, index));
        if (permissionInstances.isEmpty()) {
            return;
        }
        HashMap<MethodInfo, AnnotationInstance> methodToInstanceCollector = new HashMap<MethodInfo, AnnotationInstance>();
        HashMap<ClassInfo, AnnotationInstance> classAnnotations = new HashMap<ClassInfo, AnnotationInstance>();
        Map<MethodInfo, SecurityCheck> securityChecks = new CopyPermissionSecurityChecks.PermissionSecurityChecksBuilder(recorder).gatherPermissionsAllowedAnnotations(permissionInstances, methodToInstanceCollector, classAnnotations).validatePermissionClasses(index).createPermissionPredicates().build().get();
        if (securityChecks.isEmpty()) {
            return;
        }
        this.buildSecurityChecks(securityChecks, additionalSecurityChecks, config, index);
    }

    private void buildSecurityChecks(Map<MethodInfo, SecurityCheck> securityChecks, BuildProducer<AdditionalSecurityCheckBuildItem> additionalSecurityChecks, SecurityBuildTimeConfig config, IndexView index) {
        for (Map.Entry<MethodInfo, SecurityCheck> e : securityChecks.entrySet()) {
            MethodInfo methodInfo = e.getKey();
            ClassInfo tmp = methodInfo.declaringClass();
            if (!tmp.isInterface() || SecurityProcessor.isNotPackage(config, tmp.name())) continue;
            Collection classes = index.getKnownDirectImplementors(tmp.name());
            for (ClassInfo clas : classes) {
                MethodInfo method;
                if (SecurityProcessor.isNotPackage(config, clas.name()) || (method = clas.method(methodInfo.name(), methodInfo.parameterTypes().toArray(new Type[0]))) == null || method.hasAnnotation(DotNames.PERMISSIONS_ALLOWED)) continue;
                additionalSecurityChecks.produce((BuildItem)new AdditionalSecurityCheckBuildItem(method, e.getValue()));
            }
        }
    }

    @BuildStep
    void transform(SecurityBuildTimeConfig config, CombinedIndexBuildItem ci, BuildProducer<AnnotationsTransformerBuildItem> transformer) {
        if (!config.mapping().enabled()) {
            log.info("Security annotation mapping is disabled");
            return;
        }
        IndexView index = ci.getIndex();
        transformer.produce((BuildItem)new AnnotationsTransformerBuildItem(AnnotationTransformation.forMethods().whenMethod(m -> !m.hasAnnotation(DotNames.PERMISSIONS_ALLOWED) && !m.declaringClass().isInterface() && !SecurityProcessor.isNotPackage(config, m.declaringClass().name())).transform(context -> {
            AnnotationInstance ai = SecurityProcessor.findAnnotationInstance(context.declaration().asMethod(), index, config);
            if (ai == null) {
                return;
            }
            List<AnnotationValue> values = ai.value().asArrayList().stream().map(x -> AnnotationValue.createStringValue((String)x.name(), (String)x.asString())).toList();
            context.add(AnnotationInstance.builder((DotName)DotNames.PERMISSIONS_ALLOWED).add(AnnotationValue.createArrayValue((String)"value", values)).build());
        })));
    }

    private static boolean isNotPackage(SecurityBuildTimeConfig config, DotName name) {
        String n = name.toString();
        Optional<String> add = config.mapping().packages().stream().filter(n::startsWith).findFirst();
        return add.isEmpty();
    }

    private static AnnotationInstance findAnnotationInstance(MethodInfo method, IndexView index, SecurityBuildTimeConfig config) {
        ClassInfo classInfo = method.declaringClass();
        List interfaces = classInfo.interfaceNames();
        for (DotName item : interfaces) {
            AnnotationInstance ai;
            MethodInfo m;
            ClassInfo ite = index.getClassByName(item);
            if (ite == null || SecurityProcessor.isNotPackage(config, ite.name()) || (m = ite.method(method.name(), method.parameterTypes().toArray(new Type[0]))) == null || (ai = m.annotation(DotNames.PERMISSIONS_ALLOWED)) == null) continue;
            return ai;
        }
        return null;
    }
}

