/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.validator.size;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.tkit.onecx.quarkus.validator.constraints.Size;
import org.tkit.onecx.quarkus.validator.parameters.SizeParameter;
import org.tkit.onecx.quarkus.validator.size.SizeValidatorService;

@Dependent
public class SizeValidator
implements ConstraintValidator<Size, Integer> {
    SizeParameter defaultSizeParameter;
    String key;
    @Inject
    Instance<SizeValidatorService> sizeValidatorService;

    public void initialize(Size constraintAnnotation) {
        this.defaultSizeParameter = new SizeParameter();
        this.defaultSizeParameter.setMax(constraintAnnotation.max());
        this.defaultSizeParameter.setMin(constraintAnnotation.min());
        this.defaultSizeParameter.setMessage(constraintAnnotation.message());
        this.key = constraintAnnotation.key();
    }

    public boolean isValid(Integer value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        SizeValidatorService.SizeValidatorResult sizeValidatorResult = ((SizeValidatorService)this.sizeValidatorService.get()).initSizeParameter(this.key, this.defaultSizeParameter);
        if ((long)value.intValue() > sizeValidatorResult.getValue().getMax()) {
            return this.violation(sizeValidatorResult, context);
        }
        if ((long)value.intValue() < sizeValidatorResult.getValue().getMin()) {
            return this.violation(sizeValidatorResult, context);
        }
        return true;
    }

    private boolean violation(SizeValidatorService.SizeValidatorResult sizeValidatorResult, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        String msg = ((SizeValidatorService)this.sizeValidatorService.get()).getMessage(sizeValidatorResult);
        context.buildConstraintViolationWithTemplate(msg).addConstraintViolation();
        return false;
    }
}

