/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.onecx.quarkus.validator.size;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import org.tkit.onecx.quarkus.validator.config.ValidatorConfig;
import org.tkit.onecx.quarkus.validator.parameters.SizeParameter;
import org.tkit.onecx.quarkus.validator.service.ValueService;

@ApplicationScoped
public class SizeValidatorService {
    @Inject
    ValidatorConfig config;
    @Inject
    Instance<ValueService> valueService;

    SizeValidatorResult initSizeParameter(String key, SizeParameter defaultSizeParameter) {
        SizeValidatorResult result = new SizeValidatorResult();
        result.key = key;
        result.defaultValue = defaultSizeParameter;
        if (!this.config.values().enabled()) {
            return result;
        }
        result.provider = ((ValueService)this.valueService.get()).getName();
        result.parameterName = this.config.values().mapping().getOrDefault(key, key);
        result.value = ((ValueService)this.valueService.get()).getValue(result.parameterName, SizeParameter.class, defaultSizeParameter);
        return result;
    }

    String getMessage(SizeValidatorResult result) {
        String template = this.config.size().template();
        return String.format(template, result.provider, result.key, result.parameterName, result.value.getMessage(), result.value.getMin(), result.value.getMax());
    }

    static class SizeValidatorResult {
        private String provider;
        private String key;
        private String parameterName;
        private SizeParameter defaultValue;
        private SizeParameter value;

        SizeValidatorResult() {
        }

        public String getKey() {
            return this.key;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public SizeParameter getDefaultValue() {
            return this.defaultValue;
        }

        public SizeParameter getValue() {
            return this.value;
        }
    }
}

