package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;


import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


/**
 * The type Open incident event.
 */
public class OpenIncidentEvent extends IncidentEvent {
    private @Valid
    String errorCode = null;
    private @Valid
    String errorMessage = null;
    private @Valid
    ErrorType errorType = null;
    private @Valid
    String externalIssueId = null;
    private @Valid @NotNull
    String nodeId = null;
    private @Valid
    PriorityLevel priority = null;
    private @Valid
    List<ResolutionOption> resolutionOptions = new ArrayList<ResolutionOption>();
    private @Valid
    Integer retryCount = null;
    private @Valid
    PriorityLevel severity = null;

    /**
     * Error code open incident event.
     *
     * @param errorCode the error code
     * @return the open incident event
     */
    public OpenIncidentEvent errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }


    /**
     * Gets error code.
     *
     * @return the error code
     */
    @JsonProperty("errorCode")

    public String getErrorCode() {
        return errorCode;
    }

    /**
     * Sets error code.
     *
     * @param errorCode the error code
     */
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    /**
     * Error message open incident event.
     *
     * @param errorMessage the error message
     * @return the open incident event
     */
    public OpenIncidentEvent errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }


    /**
     * Gets error message.
     *
     * @return the error message
     */
    @JsonProperty("errorMessage")

    public String getErrorMessage() {
        return errorMessage;
    }

    /**
     * Sets error message.
     *
     * @param errorMessage the error message
     */
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    /**
     * Error type open incident event.
     *
     * @param errorType the error type
     * @return the open incident event
     */
    public OpenIncidentEvent errorType(ErrorType errorType) {
        this.errorType = errorType;
        return this;
    }


    /**
     * Gets error type.
     *
     * @return the error type
     */
    @JsonProperty("errorType")

    public ErrorType getErrorType() {
        return errorType;
    }

    /**
     * Sets error type.
     *
     * @param errorType the error type
     */
    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    /**
     * External issue id open incident event.
     *
     * @param externalIssueId the external issue id
     * @return the open incident event
     */
    public OpenIncidentEvent externalIssueId(String externalIssueId) {
        this.externalIssueId = externalIssueId;
        return this;
    }


    /**
     * Gets external issue id.
     *
     * @return the external issue id
     */
    @JsonProperty("externalIssueId")

    public String getExternalIssueId() {
        return externalIssueId;
    }

    /**
     * Sets external issue id.
     *
     * @param externalIssueId the external issue id
     */
    public void setExternalIssueId(String externalIssueId) {
        this.externalIssueId = externalIssueId;
    }

    /**
     * Node id open incident event.
     *
     * @param nodeId the node id
     * @return the open incident event
     */
    public OpenIncidentEvent nodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }


    /**
     * Gets node id.
     *
     * @return the node id
     */
    @JsonProperty("nodeId")

    public String getNodeId() {
        return nodeId;
    }

    /**
     * Sets node id.
     *
     * @param nodeId the node id
     */
    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    /**
     * Priority open incident event.
     *
     * @param priority the priority
     * @return the open incident event
     */
    public OpenIncidentEvent priority(PriorityLevel priority) {
        this.priority = priority;
        return this;
    }


    /**
     * Gets priority.
     *
     * @return the priority
     */
    @JsonProperty("priority")

    public PriorityLevel getPriority() {
        return priority;
    }

    /**
     * Sets priority.
     *
     * @param priority the priority
     */
    public void setPriority(PriorityLevel priority) {
        this.priority = priority;
    }

    /**
     * Resolution options open incident event.
     *
     * @param resolutionOptions the resolution options
     * @return the open incident event
     */
    public OpenIncidentEvent resolutionOptions(List<ResolutionOption> resolutionOptions) {
        this.resolutionOptions = resolutionOptions;
        return this;
    }


    /**
     * Gets resolution options.
     *
     * @return the resolution options
     */
    @JsonProperty("resolutionOptions")

    public List<ResolutionOption> getResolutionOptions() {
        return resolutionOptions;
    }

    /**
     * Sets resolution options.
     *
     * @param resolutionOptions the resolution options
     */
    public void setResolutionOptions(List<ResolutionOption> resolutionOptions) {
        this.resolutionOptions = resolutionOptions;
    }

    /**
     * Retry count open incident event.
     *
     * @param retryCount the retry count
     * @return the open incident event
     */
    public OpenIncidentEvent retryCount(Integer retryCount) {
        this.retryCount = retryCount;
        return this;
    }


    /**
     * Gets retry count.
     *
     * @return the retry count
     */
    @JsonProperty("retryCount")

    public Integer getRetryCount() {
        return retryCount;
    }

    /**
     * Sets retry count.
     *
     * @param retryCount the retry count
     */
    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    /**
     * Severity open incident event.
     *
     * @param severity the severity
     * @return the open incident event
     */
    public OpenIncidentEvent severity(PriorityLevel severity) {
        this.severity = severity;
        return this;
    }


    /**
     * Gets severity.
     *
     * @return the severity
     */
    @JsonProperty("severity")

    public PriorityLevel getSeverity() {
        return severity;
    }

    /**
     * Sets severity.
     *
     * @param severity the severity
     */
    public void setSeverity(PriorityLevel severity) {
        this.severity = severity;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OpenIncidentEvent openIncidentEvent = (OpenIncidentEvent) o;
        return Objects.equals(errorCode, openIncidentEvent.errorCode) &&
                Objects.equals(errorMessage, openIncidentEvent.errorMessage) &&
                Objects.equals(errorType, openIncidentEvent.errorType) &&
                Objects.equals(externalIssueId, openIncidentEvent.externalIssueId) &&
                Objects.equals(nodeId, openIncidentEvent.nodeId) &&
                Objects.equals(priority, openIncidentEvent.priority) &&
                Objects.equals(resolutionOptions, openIncidentEvent.resolutionOptions) &&
                Objects.equals(retryCount, openIncidentEvent.retryCount) &&
                Objects.equals(severity, openIncidentEvent.severity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(errorCode, errorMessage, errorType, externalIssueId, nodeId, priority, resolutionOptions, retryCount, severity);
    }

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenIncidentEvent {\n");
        sb.append("    ").append(toIndentedString(super.toPrettyString())).append("\n");
        sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
        sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
        sb.append("    errorType: ").append(toIndentedString(errorType)).append("\n");
        sb.append("    externalIssueId: ").append(toIndentedString(externalIssueId)).append("\n");
        sb.append("    nodeId: ").append(toIndentedString(nodeId)).append("\n");
        sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
        sb.append("    resolutionOptions: ").append(toIndentedString(resolutionOptions)).append("\n");
        sb.append("    retryCount: ").append(toIndentedString(retryCount)).append("\n");
        sb.append("    severity: ").append(toIndentedString(severity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
