package org.tkit.rhpam.quarkus.emitters;

import antlr.debug.MessageAdapter;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;
import org.tkit.rhpam.quarkus.messaging.common.Constants;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.model.AdditionalErrorInfo;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import java.io.IOException;
import java.util.Map;

/**
 * The type Failed step emitter.
 */
@ApplicationScoped
@Transactional
public class FailedStepEmitter {
    /**
     * The Emitter.
     */
    @Inject
    @Channel(Constants.FAILED_STEPS_QUEUE)
    Emitter<String> emitter;

    /**
     * Send to failed step queue.
     *
     * @param message             the message
     * @param messageBody         the message body
     * @param additionalErrorInfo the additional error info
     * @param errorCode           the error code
     * @throws IOException the io exception
     */
    public void sendToFailedStepQueue(Message<String> message, Map<String, Object> messageBody, AdditionalErrorInfo additionalErrorInfo, String errorCode) throws  IOException {
       Message<String> toEmit;
        if (messageBody != null) {
            toEmit = Message.of(MessageUtil.serializeBody(messageBody), message.getMetadata());
        } else {
            toEmit = Message.of(message.getPayload(), message.getMetadata());
        }
        emitter.send(toEmit);
    }


}
