/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.emitters;

import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.model.CommandType;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecutionResult;

@ApplicationScoped
@Transactional
public class JbpmMessageEmitter {
    @Inject
    @Channel(value="jms.queue.ResponseExecutionQueue")
    Emitter<String> emitter;

    public void notifyJBPM(ProcessStepExecution execution, Message message, ProcessStepExecutionResult result) throws IOException {
        result.getParameters().put("TKIT_RESOLUTION_STATUS", result.getStatus().name());
        result.getParameters().put("TKIT_CORRELATION_ID", execution.getCorrelationId());
        Message toEmit = message.withPayload((Object)MessageUtil.serializeBody(result.getParameters()));
        OutgoingAmqpMetadata meta = OutgoingAmqpMetadata.builder().withApplicationProperty("TKIT_CMD", (Object)CommandType.COMPLETE_WORK_ITEM.name()).build();
        toEmit.addMetadata((Object)meta);
        this.emitter.send(toEmit);
    }
}

