package org.tkit.rhpam.quarkus.processlog.domain.models;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.util.Date;
import java.util.Map;

/**
 * The type Domain process info.
 */
@Entity
@Getter
@Setter
@Table(name = "pl_domain_process_info")
@ToString(of = {"id", "currentProcessId", "currentProcessStepStatus", "currentProcessStepName", "currentProcessStepStatus"})
public class DomainProcessInfo {
    @Id
    private String id;
    private boolean processActive;
    private String currentProcessId;
    private Long currentProcessInstanceId;
    @Temporal(TemporalType.TIMESTAMP)
    private Date currentProcessStartTime;
    @Enumerated(EnumType.STRING)
    private ProcessStatus currentProcessStatus;
    private String currentProcessInitiator;
    private String currentProcessStepName;
    private String currentProcessStepStatus;
    @ElementCollection(fetch = FetchType.LAZY)
    @MapKeyColumn(name = "stage")
    @CollectionTable(
            name = "pl_process_stages",
            joinColumns = @JoinColumn(name = "process_info_id")
    )
    private Map<String, StageFlag> stageFlags;

    /**
     * Instantiates a new Domain process info.
     */
    public DomainProcessInfo() {

    }

    /**
     * Instantiates a new Domain process info.
     *
     * @param domainRefKey the domain ref key
     * @param domainRefId  the domain ref id
     */
    public DomainProcessInfo(String domainRefKey, String domainRefId) {
        this.id = domainRefKey + "#" + domainRefId;
    }

    /**
     * The enum Process status.
     */
    public enum ProcessStatus {
        /**
         * Pending process status.
         */
        PENDING,
        /**
         * Running process status.
         */
        RUNNING,
        /**
         * Completed process status.
         */
        COMPLETED,
        /**
         * Error process status.
         */
        ERROR;
    }

}
