package org.tkit.rhpam.quarkus.processlog.domain.daos;

import org.tkit.rhpam.quarkus.processlog.domain.models.DomainProcessInfo;
import org.tkit.rhpam.quarkus.processlog.domain.models.StageFlag;

import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import java.util.Date;


/**
 * The type Domain process info dao.
 */
@ApplicationScoped
public class DomainProcessInfoDAO {
    @PersistenceContext
    private EntityManager em;

    /**
     * Find by domain refs domain process info.
     *
     * @param domainRefKey the domain ref key
     * @param domainRefId  the domain ref id
     * @return the domain process info
     */
    public DomainProcessInfo findByDomainRefs(String domainRefKey, String domainRefId) {
        String id = domainRefKey + "#" + domainRefId;
        return em.find(DomainProcessInfo.class, id);
    }

    /**
     * Select for update domain process info.
     *
     * @param domainRefKey the domain ref key
     * @param domainRefId  the domain ref id
     * @return the domain process info
     */
    @Transactional(Transactional.TxType.REQUIRED)
    public DomainProcessInfo selectForUpdate(String domainRefKey, String domainRefId) {
        String id = domainRefKey + "#" + domainRefId;
        return em.find(DomainProcessInfo.class, id, LockModeType.PESSIMISTIC_WRITE);
    }

    /**
     * Update domain process info.
     *
     * @param toUpdate the to update
     * @return the domain process info
     */
    @Transactional(Transactional.TxType.REQUIRED)
    public DomainProcessInfo update(DomainProcessInfo toUpdate) {
        toUpdate = em.merge(toUpdate);
        em.flush();
        return toUpdate;
    }

    /**
     * Add stage flag domain process info.
     *
     * @param domainRefKey the domain ref key
     * @param domainRefId  the domain ref id
     * @param flagName     the flag name
     * @param date         the date
     * @param info         the info
     * @return the domain process info
     */
    @Transactional(Transactional.TxType.REQUIRED)
    public DomainProcessInfo addStageFlag(String domainRefKey, String domainRefId, String flagName, Date date, String info) {
        DomainProcessInfo dpi = this.selectForUpdate(domainRefKey, domainRefId);
        StageFlag stageFlag = new StageFlag();
        stageFlag.setDate(date);
        stageFlag.setInfo(info);
        dpi.getStageFlags().put(flagName, stageFlag);
        return this.update(dpi);
    }
}
