/*
 * Decompiled with CFR 0.152.
 */
package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import ext.api.centrallog.model.EventType;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class ProcessLogEvent {
    @Valid
    private String correlationId = null;
    @Valid
    @NotNull
    private Date eventTime = null;
    @Valid
    @NotNull
    private EventType processEventType = null;
    @Valid
    @NotNull
    private String processInstanceId = null;
    @Valid
    @NotNull
    private String processId = null;
    @Valid
    private Map<String, Object> metadata = new HashMap<String, Object>();
    @Valid
    @NotNull
    private String executionId = null;

    public ProcessLogEvent correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @JsonProperty(value="correlationId")
    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public ProcessLogEvent eventTime(Date eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @JsonProperty(value="eventTime")
    public Date getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public ProcessLogEvent processEventType(EventType processEventType) {
        this.processEventType = processEventType;
        return this;
    }

    @JsonProperty(value="processEventType")
    public EventType getProcessEventType() {
        return this.processEventType;
    }

    public void setProcessEventType(EventType processEventType) {
        this.processEventType = processEventType;
    }

    public ProcessLogEvent processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @JsonProperty(value="processInstanceId")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public ProcessLogEvent processId(String processId) {
        this.processId = processId;
        return this;
    }

    @JsonProperty(value="processId")
    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public ProcessLogEvent metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonProperty(value="metadata")
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public ProcessLogEvent executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @JsonProperty(value="executionId")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessLogEvent processLogEvent = (ProcessLogEvent)o;
        return Objects.equals(this.correlationId, processLogEvent.correlationId) && Objects.equals(this.eventTime, processLogEvent.eventTime) && Objects.equals((Object)this.processEventType, (Object)processLogEvent.processEventType) && Objects.equals(this.processInstanceId, processLogEvent.processInstanceId) && Objects.equals(this.processId, processLogEvent.processId) && Objects.equals(this.metadata, processLogEvent.metadata) && Objects.equals(this.executionId, processLogEvent.executionId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.correlationId, this.eventTime, this.processEventType, this.processInstanceId, this.processId, this.metadata, this.executionId});
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessLogEvent {\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    processEventType: ").append(this.toIndentedString((Object)this.processEventType)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processId: ").append(this.toIndentedString(this.processId)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" { processInstance: " + this.getProcessInstanceId());
        sb.append(", executionId: " + this.getExecutionId());
        sb.append(", processId: " + this.getProcessId());
        sb.append(" }");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

