package org.tkit.rhpam.quarkus.messaging.emitters;


import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMessage;
import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.model.AdditionalErrorInfo;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import java.io.IOException;
import java.util.Map;


/**
 * The type Failed step emitter.
 */
@ApplicationScoped
@Transactional
public class FailedStepEmitter {
    /**
     * The Emitter.
     */
    @Inject
    @Channel("tkitRhpamFailedSteps")
    Emitter<String> emitter;

    /**
     * Send to failed step queue.
     *
     * @param message             the message
     * @param messageBody         the message body
     * @param additionalErrorInfo the additional error info
     * @param errorCode           the error code
     * @throws IOException the io exception
     */
    public void sendToFailedStepQueue(AmqpMessage<String> message, Map<String, Object> messageBody, AdditionalErrorInfo additionalErrorInfo,
                                      String errorCode) throws IOException {

        OutgoingAmqpMetadata meta = OutgoingAmqpMetadata.builder()
                .withApplicationProperties(message.getApplicationProperties())
                .withApplicationProperty("TKIT_FAILED_STEP", true)
                .build();
        Message<String> toEmit;
        if (messageBody != null) {
            toEmit = Message.of(MessageUtil.serializeBody(messageBody));
        } else {
            toEmit = Message.of(message.getPayload());
        }
        toEmit = toEmit.addMetadata(meta);

        emitter.send(toEmit);
    }


}
