package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.Valid;
import java.util.Objects;


/**
 * The type Resolved incident event.
 */
public class ResolvedIncidentEvent extends IncidentEvent {
    private @Valid
    String resolutionKey = null;
    private @Valid
    String resolutionSource = null;
    private @Valid
    ResolutionStatus resolutionStatus = null;

    /**
     * Resolution key resolved incident event.
     *
     * @param resolutionKey the resolution key
     * @return the resolved incident event
     */
    public ResolvedIncidentEvent resolutionKey(String resolutionKey) {
        this.resolutionKey = resolutionKey;
        return this;
    }


    /**
     * Gets resolution key.
     *
     * @return the resolution key
     */
    @JsonProperty("resolutionKey")

    public String getResolutionKey() {
        return resolutionKey;
    }

    /**
     * Sets resolution key.
     *
     * @param resolutionKey the resolution key
     */
    public void setResolutionKey(String resolutionKey) {
        this.resolutionKey = resolutionKey;
    }

    /**
     * Resolution source resolved incident event.
     *
     * @param resolutionSource the resolution source
     * @return the resolved incident event
     */
    public ResolvedIncidentEvent resolutionSource(String resolutionSource) {
        this.resolutionSource = resolutionSource;
        return this;
    }


    /**
     * Gets resolution source.
     *
     * @return the resolution source
     */
    @JsonProperty("resolutionSource")

    public String getResolutionSource() {
        return resolutionSource;
    }

    /**
     * Sets resolution source.
     *
     * @param resolutionSource the resolution source
     */
    public void setResolutionSource(String resolutionSource) {
        this.resolutionSource = resolutionSource;
    }

    /**
     * Resolution status resolved incident event.
     *
     * @param resolutionStatus the resolution status
     * @return the resolved incident event
     */
    public ResolvedIncidentEvent resolutionStatus(ResolutionStatus resolutionStatus) {
        this.resolutionStatus = resolutionStatus;
        return this;
    }


    /**
     * Gets resolution status.
     *
     * @return the resolution status
     */
    @JsonProperty("resolutionStatus")

    public ResolutionStatus getResolutionStatus() {
        return resolutionStatus;
    }

    /**
     * Sets resolution status.
     *
     * @param resolutionStatus the resolution status
     */
    public void setResolutionStatus(ResolutionStatus resolutionStatus) {
        this.resolutionStatus = resolutionStatus;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResolvedIncidentEvent resolvedIncidentEvent = (ResolvedIncidentEvent) o;
        return Objects.equals(resolutionKey, resolvedIncidentEvent.resolutionKey) &&
                Objects.equals(resolutionSource, resolvedIncidentEvent.resolutionSource) &&
                Objects.equals(resolutionStatus, resolvedIncidentEvent.resolutionStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resolutionKey, resolutionSource, resolutionStatus);
    }

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResolvedIncidentEvent {\n");
        sb.append("    ").append(toIndentedString(super.toPrettyString())).append("\n");
        sb.append("    resolutionKey: ").append(toIndentedString(resolutionKey)).append("\n");
        sb.append("    resolutionSource: ").append(toIndentedString(resolutionSource)).append("\n");
        sb.append("    resolutionStatus: ").append(toIndentedString(resolutionStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
