package org.tkit.rhpam.quarkus.rs;

import lombok.extern.slf4j.Slf4j;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.process.RetryStepService;
import org.tkit.rhpam.quarkus.rs.model.ResolutionRequest;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@RequestScoped
@Transactional
@Path("/failedSteps/{stepId}/resolution")
@Tag(name = "failedStepsResolutionAPI")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
@Slf4j
public class FailedStepResolutionRestController {

    @Inject
    private RetryStepService retryStepService;

    @POST
    public Response resolveFailedStep(@PathParam("stepId") String failedStepId, @Parameter ResolutionRequest request) throws RhpamException {
        try {
            retryStepService.resolveFailedStep(failedStepId, request.getResolutionOption(), request.getSource() != null ? request.getSource() :
                    "INTERNAL_RESOLUTION");

            return Response.accepted().build();
            //in case of errors, just throw SE, let exception mapper turn it into 500 with proper body
        } catch (Exception e) {
            throw new RhpamException(FailedStepResolutionErrorKeys.FAILED_TO_PROCESS_RESOLUTION.name(), e);
        }
    }

    enum FailedStepResolutionErrorKeys {
        FAILED_TO_PROCESS_RESOLUTION
    }
}
