/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtil {
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtil.class);

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getExceptionStackTrace(Throwable ex) {
        if (ex != null) {
            try (StringWriter sw = new StringWriter();){
                PrintWriter pw = new PrintWriter(sw);
                try {
                    ex.printStackTrace(pw);
                    String string = sw.toString();
                    pw.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException er) {
                log.error("Error write stack trace to execution log", (Throwable)er);
            }
        }
        return null;
    }
}

